% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.theta_target.R
\name{plot.theta_target}
\alias{plot.theta_target}
\title{Method for plotting the TIF of the STF}
\usage{
\method{plot}{theta_target}(
  x,
  fun = "sum",
  theta = seq(-5, 5, length.out = 1000),
  show_targets = TRUE,
  show_both = TRUE,
  ...
)
}
\arguments{
\item{x}{Object of class \code{theta_target} obtained with function \code{theta_target()}}

\item{fun}{\code{character}, whether to consider the mean or the sum for the computation of the TIF}

\item{theta}{\code{numeric}, latent trait for the graphical representation}

\item{show_targets}{\code{logical}, default is TRUE. Whether to show or not the theta targets}

\item{show_both}{\code{logical}, default is \code{TRUE}. Whether to show or not the TIF obtained from the full-length test}

\item{...}{other arguments}
}
\value{
A \code{ggplot} showing the TIFs of both the STF and the full-length test
}
\description{
The STF is obtained with the theta target procedure
}
\examples{
set.seed(123)
n <- 50
theta <- rnorm(500)
item_par <- data.frame(
  b = runif(n, -3, 3),
  a = runif(n, 1.2, 1.9),
  c = rep(0, n),
  e = rep(1, n)
)
targets <- define_targets(theta, num_targets = 4)
resT <- theta_target(targets, item_par)
plot(resT)
# plot without showing the theta targets
plot(resT, show_targets = FALSE)
}
