% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{corp_rep_data}
\alias{corp_rep_data}
\title{Measurement Instrument for the Corporate Reputation Model}
\format{
A data frame with 344 rows and 41 variables:
\describe{
  \item{serviceprovider}{A categorical variable for the service provider: 1, 2, 3, or 4.}
  \item{servicetype}{A categorical variable for the service type: 1=Prepaid plan (n=125); 2=Contract plan (n=219).}
  \item{csor_1}{The company behaves in a socially conscious way.}
  \item{csor_2}{The company is forthright in giving information to the public.}
  \item{csor_3}{The company has a fair attitude toward competitors.}
  \item{csor_4}{The company is concerned about the preservation of the environment.}
  \item{csor_5}{The company is not only concerned about the profits.}
  \item{csor_global}{Please assess the extent to which the company acts in socially conscious ways 0 (not at all) to 7 (definitely).}
  \item{attr_1}{The company is succesful in attracting high-quality employees.}
  \item{attr_2}{I could see myself working at the company.}
  \item{attr_3}{I like the physical appearance of the company/buildings/shops, etc.}
  \item{attr_global}{Please assess the company’s overall attractiveness; 0=very low; 7=very high.}
  \item{perf_1}{The company is a very well managed company.}
  \item{perf_2}{The company is an economically stable company.}
  \item{perf_3}{The business risk for the company is modest compared to its competitors.}
  \item{perf_4}{The company has growth potential.}
  \item{perf_5}{The company has a clear vision about the future of the company.}
  \item{perf_global}{Please assess the company’s overall performance; 0=very low; 7=very high.}
  \item{qual_1}{The products/services offered by the company are of high quality.}
  \item{qual_2}{The company is an innovator, rather than an imitator with respect to industry.}
  \item{qual_3}{The company's services/products offer good quality for money.}
  \item{qual_4}{The services the company offered are good.}
  \item{qual_5}{Customer concerns are held in high regard at the company.}
  \item{qual_6}{The company is a reliable partner for customers.}
  \item{qual_7}{The company is a trustworthy company.}
  \item{qual_8}{I have a lot of respect for the company.}
  \item{qual_global}{Please assess the overall quality of the company’s activities; 0=very low; 7=very high.}
  \item{like_1}{The company is a copany that I can better identify with than other companies.}
  \item{like_2}{The company is a company that I would regret more not having if it no longer existed than other companies.}
  \item{like_3}{I regard the company as a likeable company.}
  \item{comp_1}{The company is a top competitor in its market.}
  \item{comp_2}{As far as I know, the company is recognized worldwide.}
  \item{comp_3}{I believe that the company performs at a premium level.}
  \item{cusl_1}{I would recommend the company to friends and relatives.}
  \item{cusl_2}{If I had to choose again, I would choose the company as my mobile phone services provider.}
  \item{cusl_3}{I will remain a customer of the company in the future.}
  \item{cusa}{I am satisfied with company.}
  \item{switch_1}{It takes me a great deal of time to switch to another company.}
  \item{switch_2}{It costs me too much to switch to another company.}
  \item{switch_3}{It takes a lot of effort to get used to a new company with its specific "rules" and practices.}
  \item{switch_4}{In general, it would be a hassle switching to another company.}
}
}
\usage{
corp_rep_data
}
\description{
The data set is used as measurement instrument for corporate reputation.
}
\details{
The data frame mobi contains the observed data for the model specified by Corporate Reputation.
}
\examples{
data("corp_rep_data")

}
\references{
Hair, J. F., Hult, G. T. M., Ringle, C. M., and Sarstedt, M. (2017). A Primer on Partial Least Squares Structural Equation Modeling (2nd ed.). Thousand Oakes, CA: Sage.
}
\keyword{datasets}
