% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_BCSMD.R
\name{calc_BCSMD}
\alias{calc_BCSMD}
\title{A convenience function for calculating design comparable effect sizes}
\usage{
calc_BCSMD(
  design,
  case,
  phase,
  session,
  outcome,
  cluster = NULL,
  series = NULL,
  center = 0,
  round_session = TRUE,
  treatment_name = NULL,
  FE_base = 0,
  RE_base = 0,
  RE_base_2 = NULL,
  FE_trt = 0,
  RE_trt = NULL,
  RE_trt_2 = NULL,
  corStruct = "AR1",
  varStruct = "hom",
  A = NULL,
  B = NULL,
  D = NULL,
  cover = 95,
  bound = 35,
  symmetric = TRUE,
  summary = TRUE,
  data = NULL,
  ...
)
}
\arguments{
\item{design}{Character string to specify whether data comes from a treatment
reversal (\code{"TR"}), multiple baseline across participants
(\code{"MBP"}), replicated multiple baseline across behaviors
(\code{"RMBB"}), or clustered multiple baseline across participants
(\code{"CMB"}).}

\item{case}{vector of case indicators or name of a character or factor vector
within \code{data} indicating unique cases.}

\item{phase}{vector of treatment indicators or name of a character or factor
vector within \code{data} indicating unique treatment phases.}

\item{session}{vector of measurement occasions or name of numeric vector
within \code{data} of measurement times.}

\item{outcome}{vector of outcome data or name of numeric vector of outcome
data within \code{data}.}

\item{cluster}{(Optional) vector of cluster indicators or name of a character
or factor vector within \code{data} indicating clusters.}

\item{series}{(Optional) vector of series indicators or name of a character
or factor vector within \code{data} indicating series.}

\item{center}{Numeric value for the centering value for session. Default is 0.}

\item{round_session}{Logical indicating whether to round \code{session} to the nearest integer. Defaults to \code{TRUE}.}

\item{treatment_name}{(Optional) character string corresponding to the name
of the treatment phase.}

\item{FE_base}{Vector of integers specifying which fixed effect terms to
include in the baseline phase. Setting \code{FE_base = 0} includes only a
level. Setting \code{FE_base = c(0,1)} includes a level and a linear time
trend.}

\item{RE_base}{Vector of integers specifying which random effect terms to
include in the baseline phase. Setting \code{RE_base = 0} includes only
levels (i.e., random intercepts). Setting \code{RE_base = c(0,1)} includes
random levels and random linear trends.}

\item{RE_base_2}{Vector of integers specifying which random effect terms to
include in the baseline phase for the cluster level in clustered multiple
baseline design across participants or for the case level in replicated
multiple baseline across behaviors. Setting \code{RE_base_2 = 0} includes
only levels (i.e., random intercepts). Setting \code{RE_base_2 = c(0,1)}
includes random levels and random linear trends.}

\item{FE_trt}{Vector of integers specifying which fixed effect terms to
include in the treatment phase. Setting \code{FE_trt = 0} includes only a
change in level. Setting \code{FE_trt = c(0,1)} includes a change in level
and a treatment-by-linear time trend.}

\item{RE_trt}{Vector of integers specifying which random effect terms to
include in the treatment phase. Setting \code{RE_trt = 0} includes only
random changes in level. Setting \code{RE_trt = c(0,1)} includes random
changes in level and random treatment-by-linear time trends.}

\item{RE_trt_2}{Vector of integers specifying which random effect terms to
include in the treatment phase for the cluster level in clustered multiple
baseline design across participants or for the case level in replicated
multiple baseline across behaviors. Setting \code{RE_trt_2 = 0} includes
only random changes in level. Setting \code{RE_trt_2 = c(0,1)} includes
random changes in level and random treatment-by-linear time trends.}

\item{corStruct}{(Optional) character string indicating the correlation
structure of session-level errors. Options are \code{"AR1"} (default),
\code{"MA1"}, or \code{"IID"}.}

\item{varStruct}{(Optional) character string indicating the
heteroscedasticity structure of session-level errors. Options are
\code{"hom"} (default) or \code{"het"}, which allows for the session-level
error variances to differ by phase.}

\item{A}{The time point immediately before the start of treatment in the
hypothetical between-group design.}

\item{B}{The time point at which outcomes are measured in the hypothetical
between-group design.}

\item{D}{Numerical indicating the treatment duration across cases. Note that
\code{B = A + D} and it is not allowed to specify both \code{B} and
\code{D}.}

\item{cover}{Confidence level.}

\item{bound}{Numerical tolerance for non-centrality parameter in
\code{\link[stats]{qt}}.}

\item{symmetric}{If \code{TRUE} (the default), use a symmetric confidence
interval. If \code{FALSE}, use a non-central t approximation to obtain an
asymmetric confidence interval.}

\item{summary}{Logical indicating whether to return a data frame with effect
size estimates and other information. If \code{TRUE} (default), return a
\code{data.frame} containing the effect size estimate, standard error,
confidence interval, and other information. If \code{FALSE}, return a list
with effect size estimate, degrees of freedom, and other information.}

\item{data}{(Optional) dataset to use for analysis. Must be a
\code{data.frame}.}

\item{...}{further arguments.}
}
\value{
If \code{summary == TRUE}, a data frame containing the
  design-comparable effect size estimate, standard error, confidence
  interval, and other information. If \code{summary == FALSE}, a list
  containing all elements of a `g_mlm()` object, plus the fitted `lme()`
  model.
}
\description{
In one call, 1) clean single-case design data for treatment
  reversal and multiple baseline designs, 2) fit a multi-level model using
  restricted maximum likelihood estimation, and 3) estimate a standardized
  mean difference effect size.
}
\examples{
data(Laski)

# Change-in-levels model with fixed treatment effect
calc_BCSMD(design = "MBP",
           case = case, phase = treatment,
           session = time, outcome = outcome,
           FE_base = 0, RE_base = 0, FE_trt = 0,
           data = Laski)

# Model with linear time trends in baseline and treatment phases,
# random baseline slopes, fixed treatment effects
calc_BCSMD(design = "MBP",
           case = case, phase = treatment,
           session = time, outcome = outcome, center = 4,
           FE_base = c(0,1), RE_base = c(0,1), 
           FE_trt = c(0,1),
           data = Laski)


data(Anglesea)
calc_BCSMD(design = "TR",
           case = case, phase = condition,
           session = session, outcome = outcome,
           treatment_name = "treatment",
           FE_base = 0, RE_base = 0, 
           FE_trt = 0,
           data = Anglesea)


data(Thiemann2001)
calc_BCSMD(design = "RMBB",
           case = case, series = series, phase = treatment,
           session = time, outcome = outcome,
           FE_base = 0, RE_base = 0, RE_base_2 = 0, 
           FE_trt = 0,
           data = Thiemann2001)


data(Bryant2018)
calc_BCSMD(design = "CMB",
           cluster = group, case = case, phase = treatment,
           session = session, outcome = outcome, center = 49,
           treatment_name = "treatment",
           FE_base = c(0,1), RE_base = 0, RE_base_2 = 0,
           FE_trt = c(0,1), RE_trt = NULL, RE_trt_2 = NULL,
           data = Bryant2018)


}
