% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeme.R
\name{makeme}
\alias{makeme}
\title{Embed Interactive Plot of Various Kinds Using Tidyselect Syntax}
\usage{
makeme(
  data,
  dep = tidyselect::everything(),
  indep = NULL,
  type = c("auto", "cat_plot_html", "int_plot_html", "cat_table_html", "int_table_html",
    "sigtest_table_html", "cat_prop_plot_docx", "cat_freq_plot_docx", "int_plot_docx"),
  ...,
  require_common_categories = TRUE,
  crowd = c("all"),
  mesos_var = NULL,
  mesos_group = NULL,
  simplify_output = TRUE,
  hide_for_crowd_if_all_na = TRUE,
  hide_for_crowd_if_valid_n_below = 0,
  hide_for_crowd_if_category_k_below = 2,
  hide_for_crowd_if_category_n_below = 0,
  hide_for_crowd_if_cell_n_below = 0,
  hide_for_all_crowds_if_hidden_for_crowd = NULL,
  hide_indep_cat_for_all_crowds_if_hidden_for_crowd = FALSE,
  add_n_to_dep_label = FALSE,
  add_n_to_indep_label = FALSE,
  add_n_to_label = FALSE,
  add_n_to_category = FALSE,
  totals = FALSE,
  categories_treated_as_na = NULL,
  label_separator = " - ",
  error_on_duplicates = TRUE,
  showNA = c("ifany", "always", "never"),
  data_label = c("percentage_bare", "percentage", "proportion", "count", "mean",
    "median"),
  data_label_position = c("center", "bottom", "top", "above"),
  html_interactive = TRUE,
  hide_axis_text_if_single_variable = TRUE,
  hide_label_if_prop_below = 0.01,
  inverse = FALSE,
  vertical = FALSE,
  digits = 0,
  data_label_decimal_symbol = ".",
  x_axis_label_width = 25,
  strip_width = 25,
  sort_dep_by = ".variable_position",
  sort_indep_by = ".factor_order",
  sort_by = NULL,
  descend = TRUE,
  descend_indep = FALSE,
  labels_always_at_top = NULL,
  labels_always_at_bottom = NULL,
  table_wide = TRUE,
  table_main_question_as_header = FALSE,
  n_categories_limit = 12,
  translations = list(last_sep = " and ", table_heading_N = "Total (N)",
    table_heading_data_label = "\%", add_n_to_dep_label_prefix = " (N = ",
    add_n_to_dep_label_suffix = ")", add_n_to_indep_label_prefix = " (N = ",
    add_n_to_indep_label_suffix = ")", add_n_to_label_prefix = " (N = ",
    add_n_to_label_suffix = ")", add_n_to_category_prefix = " (N = [",
    add_n_to_category_infix = ",", add_n_to_category_suffix = "])", by_total =
    "Everyone", sigtest_variable_header_1 = "Var 1", sigtest_variable_header_2 = "Var 2",
    crowd_all = "All", 
     crowd_target = "Target", crowd_others = "Others"),
  plot_height = 15,
  colour_palette = NULL,
  colour_2nd_binary_cat = "#ffffff",
  colour_na = "grey",
  label_font_size = 6,
  main_font_size = 6,
  strip_font_size = 6,
  legend_font_size = 6,
  font_family = "sans",
  path = NULL,
  docx_template = NULL
)
}
\arguments{
\item{data}{\emph{Your data.frame/tibble or srvyr-object (experimental)}

\code{data.frame} // \emph{required}

The data to be used for plotting.}

\item{dep, indep}{\emph{Variable selections}

<\code{tidyselect}> // \emph{Default:} \code{NULL}, meaning everything for dep, nothing for indep.

Columns in \code{data}. \code{dep} is compulsory.}

\item{type}{\emph{Kind of output}

\verb{scalar<character>} // \emph{default:} \code{"auto"} (\code{optional})

The type of output to generate. Use \code{"auto"} (default) to automatically
detect the appropriate type based on your dependent variables:
\itemize{
\item Numeric/integer variables → \code{"int_plot_html"}
\item Factor/character variables → \code{"cat_plot_html"}
}

For a list of all registered types in your session, use \code{get_makeme_types()}.}

\item{...}{\emph{Dynamic dots}

<\href{https://rlang.r-lib.org/reference/dyn-dots.html}{\code{dynamic-dots}}>

Arguments forwarded to the corresponding functions that create the elements.}

\item{require_common_categories}{\emph{Check common categories}

\verb{scalar<logical>} // \emph{default:} \code{TRUE} (\code{optional})

Whether to check if all items share common categories.}

\item{crowd}{\emph{Which group(s) to display results for}

\verb{vector<character>} // \emph{default:} \code{c("target", "others", "all")} (\code{optional})

Choose whether to produce results for target (mesos) group, others, all, or
combinations of these.}

\item{mesos_var}{\emph{Variable in \code{data} indicating groups to tailor reports for}

\verb{scalar<character>} // \emph{default:} \code{NULL} (\code{optional})

Column name in data indicating the groups for which mesos reports will be produced.}

\item{mesos_group}{\verb{scalar<character>} // \emph{default:} \code{NULL} (\code{optional})

String, target group.}

\item{simplify_output}{\verb{scalar<logical>} // \emph{default:} \code{TRUE}

If TRUE, a list output with a single output element will return the element
itself, whereas list with multiple elements will return the list.}

\item{hide_for_crowd_if_all_na}{\emph{Hide variable from output if containing all NA}

\verb{scalar<boolean>} // \emph{default:} \code{TRUE}

Whether to remove all variables (in particular useful for mesos) if all values are NA}

\item{hide_for_crowd_if_valid_n_below}{\emph{Hide variable if variable has < n observations}

\verb{scalar<integer>} // \emph{default:} \code{0}

Whether to hide a variable for a crowd if variable contains fewer than n observations (always ignoring NA).}

\item{hide_for_crowd_if_category_k_below}{\emph{Hide variable if < k categories}

\verb{scalar<integer>} // \emph{default:} \code{2}

Whether to hide a variable for a crowd if variable contains fewer than k used categories (always ignoring NA).
Defaults to \code{2} because a unitary plot/table is rarely informative.}

\item{hide_for_crowd_if_category_n_below}{\emph{Hide variable if having a category with < n observations}

\verb{scalar<integer>} // \emph{default:} \code{0}

Whether to hide a variable for a crowd if variable contains a category with less than n observations (ignoring NA)
Cells with a 0 count is not considered as these are usually not a problem for anonymity.}

\item{hide_for_crowd_if_cell_n_below}{\emph{Hide variable if having a cell with < n}

\verb{scalar<integer>} // \emph{default:} \code{0}

Whether to hide a variable for a crowd if the combination of dep-indep results in a cell with less than n observations (ignoring NA).
Cells with a 0 count is not considered as these are usually not a problem for anonymity.}

\item{hide_for_all_crowds_if_hidden_for_crowd}{\emph{Conditional hiding}

\verb{scalar<character>} // \emph{default:} \code{NULL} (\code{optional})

Select one of the \code{crowd} output groups. If selected, will hide a variable across
all \code{crowd}-outputs if it for some reason is not displayed for
\code{hide_for_all_if_hidden_for_crowd}. For instance, say:

\verb{crowd = c("target", "others"), hide_variable_if_all_na = TRUE,}
\code{hide_for_all_if_hidden_for_crowd = "target"}

will hide variables from both target and others-outputs if all are NA in
the target-group.}

\item{hide_indep_cat_for_all_crowds_if_hidden_for_crowd}{\emph{Conditionally hide independent categories}

\verb{scalar<logical>} // \emph{default:} \code{FALSE}

If \code{hide_for_all_crowds_if_hidden_for_crowd} is specified, should categories of the
\code{indep} variable(s) be hidden for a crowd if it does not exist for the
crowds specified in \code{hide_for_all_crowds_if_hidden_for_crowd}? This is useful when e.g.
\code{indep} is academic disciplines, \code{mesos_var} is institutions, and a specific
institution is not interested in seeing academic disciplines they do not offer themselves.}

\item{add_n_to_dep_label, add_n_to_indep_label}{\emph{Add N= to the variable label}

\verb{scalar<logical>} // \emph{default:} \code{FALSE} (\code{optional})

For some plots and tables it is useful to attach the \code{"N="} to the end of the label of
the dependent and/or independent variable.
Whether it is \code{N} or \code{N_valid} depends on your \code{showNA}-setting. See also
\code{translations$add_n_to_dep_label_prefix},
\code{translations$add_n_to_dep_label_suffix},
\code{translations$add_n_to_indep_label_prefix},
\code{translations$add_n_to_indep_label_suffix}.}

\item{add_n_to_label}{\emph{Add N= to the variable label of both dep and indep}

\verb{scalar<logical>} // \emph{default:} \code{FALSE} (\code{optional})

For some plots and tables it is useful to attach the \code{"N="} to the end of the label.
Whether it is \code{N} or \code{N_valid} depends on your \code{showNA}-setting. See also
\code{translations$add_n_to_label_prefix} and
\code{translations$add_n_to_label_suffix}.}

\item{add_n_to_category}{\emph{Add N= to the category}

\verb{scalar<logical>} // \emph{default:} \code{FALSE} (\code{optional})

For some plots and tables it is useful to attach the \code{"N="} to the end of the category.
This will likely produce a range across the variables, hence an infix (comma)
between the minimum and maximum can be specified.
Whether it is \code{N} or \code{N_valid} depends on your \code{showNA}-setting. See also
\code{translations$add_n_to_category_prefix},
\code{translations$add_n_to_category_infix}, and
\code{translations$add_n_to_category_suffix}.}

\item{totals}{\emph{Include totals}

\verb{scalar<logical>} // \emph{default:} \code{FALSE} (\code{optional})

Whether to include totals in the output.}

\item{categories_treated_as_na}{\emph{NA categories}

\verb{vector<character>} // \emph{default:} \code{NULL} (\code{optional})

Categories that should be treated as NA.}

\item{label_separator}{\emph{How to separate main question from sub-question}

\verb{scalar<character>} // \emph{default:} \code{NULL} (\code{optional})

Separator for main question from sub-question.}

\item{error_on_duplicates}{\emph{Error or warn on duplicate labels}

\verb{scalar<logical>} // \emph{default:} \code{TRUE} (\code{optional})

Whether to abort (\code{TRUE}) or warn (\code{FALSE}) if the same label (suffix) is
used across multiple variables.}

\item{showNA}{\emph{Show NA categories}

\verb{vector<character>} // \emph{default:} \code{c("ifany", "always", "never")} (\code{optional})

Choose whether to show NA categories in the results.}

\item{data_label}{\emph{Data label}

\verb{scalar<character>} // \emph{default:} \code{"proportion"} (\code{optional})

One of "proportion", "percentage", "percentage_bare", "count", "mean", or "median".}

\item{data_label_position}{\emph{Data label position}

\verb{scalar<character>} // \emph{default:} \code{"center"} (\code{optional})

Position of data labels on bars. One of "center" (middle of bar), "bottom" (bottom but inside bar),
"top" (top but inside bar), or "above" (above bar outside).}

\item{html_interactive}{\emph{Toggle interactive plot}

\verb{scalar<logical>} // \emph{default:} \code{TRUE} (\code{optional})

Whether the plot is to be interactive (ggiraph) or static (ggplot2).}

\item{hide_axis_text_if_single_variable}{\emph{Hide y-axis text if just a single variable}

\verb{scalar<boolean>} // \emph{default:} \code{FALSE} (\code{optional})

Whether to hide text on the y-axis label if just a single variable.}

\item{hide_label_if_prop_below}{\emph{Hide label threshold}

\verb{scalar<numeric>} // \emph{default:} \code{NULL} (\code{optional})

Whether to hide label if below this value.}

\item{inverse}{\emph{Flag to swap x-axis and faceting}

\verb{scalar<logical>} // \emph{default:} \code{FALSE} (\code{optional})

If TRUE, swaps x-axis and faceting.}

\item{vertical}{\emph{Display plot vertically}

\verb{scalar<logical>} // \emph{default:} \code{FALSE} (\code{optional})

If TRUE, display plot vertically.}

\item{digits}{\emph{Decimal places}

\verb{scalar<integer>} // \emph{default:} \code{0L} (\code{optional})

Number of decimal places.}

\item{data_label_decimal_symbol}{\emph{Decimal symbol}

\verb{scalar<character>} // \emph{default:} \code{"."} (\code{optional})

Decimal marker, some might prefer a comma ',' or something else entirely.}

\item{x_axis_label_width, strip_width}{\emph{Label width of x-axis and strip texts in plots}

\verb{scalar<integer>} // \emph{default:} \code{20} (\code{optional})

Width of the labels used for the categorical column names in x-axis texts and strip texts.}

\item{sort_dep_by}{\emph{What to sort dependent variables by}

\verb{vector<character>} // \emph{default:} \code{".variable_position"} (\code{optional})

Sort dependent variables in output. When using \code{indep}-argument,
sorting differs between ordered factors and unordered factors: Ordering
of ordered factors is always respected in output (their levels define
the base order). Unordered factors will be reordered by \code{sort_dep_by}.

\describe{
\item{NULL or ".variable_position"}{Sort by variable position in the supplied data frame (default).}
\item{".variable_label"}{Sort by the variable labels.}
\item{".variable_name"}{Sort by the variable names.}
\item{".top"}{The proportion for the highest category available in the variable.}
\item{".upper"}{The sum of the proportions for the categories above the middle category.}
\item{".mid_upper"}{The sum of the proportions for the categories including and above the middle category.}
\item{".mid_lower"}{The sum of the proportions for the categories including and below the middle category.}
\item{".lower"}{The sum of the proportions for the categories below the middle category.}
\item{".bottom"}{The proportions for the lowest category available in the variable.}
}}

\item{sort_indep_by}{\emph{What to sort independent variable categories by}

\verb{vector<character>} // \emph{default:} \code{".factor_order"} (\code{optional})

Sort independent variable categories in output. When \code{".factor_order"},
preserves the original factor level order for the independent variable.
Passing \code{NULL} is accepted and treated as \code{".factor_order"}.

\describe{
\item{NULL}{No sorting - preserves original factor level order (default).}
\item{".top"}{The proportion for the highest category available.}
\item{".upper"}{The sum of the proportions for the categories above the middle category.}
\item{".mid_upper"}{The sum of the proportions for the categories including and above the middle category.}
\item{".mid_lower"}{The sum of the proportions for the categories including and below the middle category.}
\item{".lower"}{The sum of the proportions for the categories below the middle category.}
\item{".bottom"}{The proportions for the lowest category available.}
\item{character()}{Character vector of category labels to sum together.}
}}

\item{sort_by}{\emph{What to sort output by (legacy)}

\verb{vector<character>} // \emph{default:} \code{NULL} (\code{optional})

\strong{DEPRECATED:} Use \code{sort_dep_by} and \code{sort_indep_by} instead for clearer control.
When specified, this parameter will be used for both dependent and independent sorting.
If \code{NULL} (default), dependent variables will be sorted by \code{.variable_position}.

\describe{
\item{NULL}{Uses \code{.variable_position} for dependent variables, no sorting for independent.}
\item{".top"}{The proportion for the highest category available in the variable.}
\item{".upper"}{The sum of the proportions for the categories above the middle category.}
\item{".mid_upper"}{The sum of the proportions for the categories including and above the middle category.}
\item{".mid_lower"}{The sum of the proportions for the categories including and below the middle category.}
\item{".lower"}{The sum of the proportions for the categories below the middle category.}
\item{".bottom"}{The proportions for the lowest category available in the variable.}
\item{".variable_label"}{Sort by the variable labels.}
\item{".variable_name"}{Sort by the variable names.}
\item{".variable_position"}{Sort by the variable position in the supplied data frame.}
\item{".by_group"}{The groups of the by argument.}
\item{character()}{Character vector of category labels to sum together.}
}}

\item{descend}{\emph{Sorting order}

\verb{scalar<logical>} // \emph{default:} \code{FALSE} (\code{optional})

Reverse sorting of \code{sort_by} in figures and tables. Works with both
ordered and unordered factors - for ordered factors, it reverses the
display order while preserving the inherent level ordering.
See \code{arrange_section_by} for sorting of report sections.}

\item{descend_indep}{\emph{Sorting order for independent variables}

\verb{scalar<logical>} // \emph{default:} \code{FALSE} (\code{optional})

Reverse sorting of \code{sort_indep_by} in figures and tables. Works with both
ordered and unordered factors - for ordered factors, it reverses the
display order while preserving the inherent level ordering.
See \code{arrange_section_by} for sorting of report sections.}

\item{labels_always_at_top, labels_always_at_bottom}{\emph{Top/bottom variables}

\verb{vector<character>} // \emph{default:} \code{NULL} (\code{optional})

Column names in \code{data} that should always be placed at the top or bottom of figures/tables.}

\item{table_wide}{\emph{Pivot table wider}

\verb{scalar<logical>} // \emph{default:} \code{FALSE} (\code{optional})

Whether to pivot table wider.}

\item{table_main_question_as_header}{\emph{Table main question as header}

\verb{scalar<logical>} // \emph{default:} \code{FALSE} (\code{optional})

Whether to include the main question as a header in the table.}

\item{n_categories_limit}{\emph{Limit for cat_table_ wide format}

\verb{scalar<integer>} // \emph{default:} \code{12} (\code{optional})

If there are more than this number of categories in the categorical variable,
cat_table_* will have a long format instead of wide format.}

\item{translations}{\emph{Localize your output}

\verb{list<character>}

A list of translations where the name is the code and the value is the translation. See the examples.}

\item{plot_height}{\emph{DOCX-setting}

\verb{scalar<numeric>} // \emph{default:} \code{12} (\code{optional})

DOCX plots need a height, which currently cannot be set easily with a Quarto chunk option.}

\item{colour_palette}{\emph{Colour palette}

\verb{vector<character>} // \emph{default:} \code{NULL} (\code{optional})

Must contain at least the number of unique values (including missing) in the data set.}

\item{colour_2nd_binary_cat}{\emph{Colour for second binary category}

\verb{scalar<character>} // \emph{default:} \code{"#ffffff"} (\code{optional})

Colour for the second category in binary variables. Often useful to hide this.}

\item{colour_na}{\emph{Colour for NA category}

\verb{scalar<character>} // \emph{default:} \code{NULL} (\code{optional})

Colour as a single string for NA values, if showNA is "ifany" or "always".}

\item{main_font_size, label_font_size, strip_font_size, legend_font_size}{\emph{Font sizes}

\verb{scalar<integer>} // \emph{default:} \code{6} (\code{optional})

ONLY FOR DOCX-OUTPUT. Other output is adjusted using e.g. ggplot2::theme() or set with a global theme (ggplot2::set_theme()).
Font sizes for general text (6), data label text (3), strip text (6) and legend text (6).}

\item{font_family}{\emph{Font family}

\verb{scalar<character>} // \emph{default:} \code{"sans"} (\code{optional})

Word font family. See officer::fp_text.}

\item{path}{\emph{Output path for DOCX}

\verb{scalar<character>} // \emph{default:} \code{NULL} (\code{optional})

Path to save docx-output.}

\item{docx_template}{\emph{Filename or rdocx object}

\verb{scalar<character>|<rdocx>-object} // \emph{default:} \code{NULL} (\code{optional})

Can be either a valid character path to a reference Word file, or an existing rdocx-object in memory.}
}
\value{
ggplot-object, optionally an extended ggplot object with ggiraph features.
}
\description{
This function allows embedding of interactive or static plots based on various types of data using tidyselect syntax for variable selection.
}
\examples{
makeme(
  data = ex_survey,
  dep = b_1:b_2
)
makeme(
  data = ex_survey,
  dep = b_1:b_3, indep = c(x1_sex, x2_human),
  type = "sigtest_table_html"
)
makeme(
  data = ex_survey,
  dep = p_1:p_4, indep = x2_human,
  type = "cat_table_html"
)
makeme(
  data = ex_survey,
  dep = c_1:c_2, indep = x1_sex,
  type = "int_table_html"
)
makeme(
  data = ex_survey,
  dep = b_1:b_2,
  crowd = c("target", "others"),
  mesos_var = "f_uni",
  mesos_group = "Uni of A"
)
}
