% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sorting_utils.R
\name{add_sorting_order_vars}
\alias{add_sorting_order_vars}
\title{Create sorting order variables for output dataframe}
\usage{
add_sorting_order_vars(
  data,
  sort_dep_by = ".variable_position",
  sort_indep_by = ".factor_order",
  sort_category_by = NULL,
  descend = FALSE,
  descend_indep = FALSE
)
}
\arguments{
\item{data}{Dataset with survey results}

\item{sort_dep_by}{How to sort dependent variables}

\item{sort_indep_by}{How to sort independent variable categories}

\item{sort_category_by}{How to sort response categories}

\item{descend}{Whether to reverse the dependent variable order}
}
\value{
Dataset with added order columns: .dep_order, .indep_order, .category_order
}
\description{
This module provides centralized sorting functionality to ensure consistent
ordering across all output types (tables, plots) by using explicit order
columns instead of relying on factor levels that can be overridden.
Apply comprehensive sorting order to survey data
}
\keyword{internal}
