% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constructors.R
\name{new_rvec_blank}
\alias{new_rvec_blank}
\alias{new_rvec_chr}
\alias{new_rvec_dbl}
\alias{new_rvec_int}
\alias{new_rvec_lgl}
\title{Create an Empty Rvec}
\usage{
new_rvec_chr(length = 0, n_draw = 1000)

new_rvec_dbl(length = 0, n_draw = 1000)

new_rvec_int(length = 0, n_draw = 1000)

new_rvec_lgl(length = 0, n_draw = 1000)
}
\arguments{
\item{length}{Desired length of rvec.
Default is \code{0}.}

\item{n_draw}{Number of draws of rvec.
Default is \code{1000}.}
}
\value{
An rvec.
}
\description{
Create an rvec, filled with \code{0}, \code{""},
or \code{FALSE}, with a given length
or number of draws.
}
\examples{
new_rvec_int()
new_rvec_lgl(length = 1, n_draw = 5)

x <- new_rvec_dbl(length = 2)
x[1] <- rnorm_rvec(n = 1, n_draw = 1000)
x[2] <- runif_rvec(n = 1, n_draw = 1000)
}
\seealso{
\itemize{
\item \code{\link[=rvec]{rvec()}}, \code{\link[=rvec_chr]{rvec_chr()}}, \code{\link[=rvec_dbl]{rvec_dbl()}}, \code{\link[=rvec_int]{rvec_int()}}, \code{\link[=rvec_lgl]{rvec_lgl()}}
Create an rvec from data.
\item \code{\link[=n_draw]{n_draw()}} Query number of draws.
}
}
