% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/columns.R
\name{set_formatter_toggle_switch}
\alias{set_formatter_toggle_switch}
\title{Set toggle switch formatter}
\usage{
set_formatter_toggle_switch(
  widget,
  column,
  size = 20,
  on_value = "on",
  off_value = "off",
  on_truthy = FALSE,
  on_color = "green",
  off_color = "red",
  clickable = TRUE
)
}
\arguments{
\item{widget}{A \code{\link[=tabulator]{tabulator()}} HTML widget.}

\item{column}{The name of the column the formatter is applied to.}

\item{size}{(numeric): The size of the switch in pixels.}

\item{on_value}{(character): The value of the cell for the switch to be on.}

\item{off_value}{(character) The value of the cell for the switch to be off.}

\item{on_truthy}{(bool): Whether to show the switch as on if the value of the cell is truthy.}

\item{on_color}{(character): The color of the switch if it is on.}

\item{off_color}{(character): The color of the switch if it is off.}

\item{clickable}{(bool): Enable switch functionality to toggle the cell value on click.}
}
\value{
The updated \code{\link[=tabulator]{tabulator()}} HTML widget
}
\description{
Set toggle switch formatter
}
\examples{
data <- data.frame(
  Language = c("R", "Python", "Julia"),
  Available = c("yes", "yes", "no")
)

tabulator(data) |>
  set_formatter_toggle_switch("Available", on_value = "yes", off_value = "no")
}
