/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.polynomials;

import internal.toolkit.base.core.math.polynomials.Coefficients;
import internal.toolkit.base.core.math.polynomials.Polynomials;
import java.util.Arrays;
import java.util.Formatter;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicReference;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.math.Complex;
import jdplus.toolkit.base.api.math.ComplexType;
import jdplus.toolkit.base.api.util.Arrays2;
import jdplus.toolkit.base.core.math.ComplexComputer;
import jdplus.toolkit.base.core.math.ComplexMath;
import jdplus.toolkit.base.core.math.ComplexUtility;
import jdplus.toolkit.base.core.math.Simplifying;
import jdplus.toolkit.base.core.math.polynomials.LeastSquaresDivision;
import jdplus.toolkit.base.core.math.polynomials.PolynomialException;
import jdplus.toolkit.base.core.math.polynomials.RootsSolver;
import jdplus.toolkit.base.core.math.polynomials.UnitRoots;
import lombok.NonNull;

public final class Polynomial {
    public static final Polynomial ZERO = new Polynomial(Coefficients.zero());
    public static final Polynomial ONE = new Polynomial(Coefficients.one());
    private final double[] coeff;
    private final AtomicReference<Complex[]> defRoots = new AtomicReference();

    public static double getEpsilon() {
        return 1.0E-9;
    }

    public static Polynomial ofInternal(@NonNull double[] coefficients) {
        if (coefficients == null) {
            throw new NullPointerException("coefficients is marked non-null but is null");
        }
        return new Polynomial(Coefficients.ofInternal(coefficients));
    }

    public static Polynomial raw(@NonNull double[] coefficients) {
        if (coefficients == null) {
            throw new NullPointerException("coefficients is marked non-null but is null");
        }
        return new Polynomial(coefficients);
    }

    public static Polynomial valueOf(double p0, double ... p) {
        if (Arrays2.isNullOrEmpty((double[])p)) {
            if (p0 == 0.0) {
                return ZERO;
            }
            if (p0 == 1.0) {
                return ONE;
            }
            return new Polynomial(new double[]{p0});
        }
        int dp = Coefficients.getUsedCoefficients(p, 0.0);
        if (dp == 0) {
            return new Polynomial(new double[]{p0});
        }
        double[] np = new double[dp + 1];
        np[0] = p0;
        System.arraycopy(p, 0, np, 1, dp);
        return new Polynomial(np);
    }

    public static Polynomial of(double ... coefficients) {
        return new Polynomial(Coefficients.of(coefficients));
    }

    public static Polynomial of(@NonNull double[] coefficients, int start, int end) {
        if (coefficients == null) {
            throw new NullPointerException("coefficients is marked non-null but is null");
        }
        double[] copy = Arrays.copyOfRange(coefficients, start, end);
        return new Polynomial(Coefficients.ofInternal(copy));
    }

    public static Polynomial fromComplexRoots(Complex[] roots) {
        return Polynomial.fromComplexRoots(roots, 1.0);
    }

    public static Polynomial fromComplexRoots(Complex[] roots, double c) {
        if (Arrays2.isNullOrEmpty((Object[])roots)) {
            return new Polynomial(new double[]{c});
        }
        double[] pcoeff = new double[roots.length + 1];
        Complex[] p = new Complex[roots.length + 1];
        p[0] = Complex.cart((double)1.0, (double)0.0);
        for (int i = 0; i < roots.length; ++i) {
            p[i + 1] = p[i];
            for (int j = i; j >= 1; --j) {
                p[j] = p[j - 1].minus(p[j].times(roots[i]));
            }
            p[0] = p[0].times(roots[i].negate());
        }
        double p0 = p[0].getRe();
        if (p0 == 0.0) {
            throw new IllegalArgumentException("Roots should all be different from 0");
        }
        double fac = c / p0;
        for (int i = 1; i < p.length; ++i) {
            pcoeff[i] = p[i].getRe() * fac;
        }
        pcoeff[0] = c;
        Polynomial pol = new Polynomial(pcoeff);
        pol.defRoots.set((Complex[])roots.clone());
        return pol;
    }

    public static Polynomial factor(double c, int n) {
        if (c == 0.0) {
            return ONE;
        }
        double[] p = new double[n + 1];
        p[0] = 1.0;
        p[n] = -c;
        Polynomial F2 = Polynomial.ofInternal(p);
        Complex[] ur = ComplexUtility.unitRoots(n);
        if (c > 0.0 || n % 2 == 1) {
            double rc = c > 0.0 ? Math.pow(1.0 / c, 1.0 / (double)n) : -Math.pow(-1.0 / c, 1.0 / (double)n);
            for (int i = 0; i < ur.length; ++i) {
                ur[i] = ur[i].times(rc);
            }
        } else {
            Complex rc = ComplexMath.pow((ComplexType)Complex.cart((double)(1.0 / c), (double)0.0), 1.0 / (double)n);
            for (int i = 0; i < ur.length; ++i) {
                ur[i] = ur[i].times(rc);
            }
        }
        F2.setRoots(ur);
        return F2;
    }

    private static Complex smooth(Complex c) {
        double re = c.getRe();
        double im = c.getIm();
        if (Math.abs(im) <= 1.0E-9) {
            im = 0.0;
        }
        if (Math.abs(re) <= 1.0E-9) {
            re = 0.0;
        }
        if (Math.abs(re - 1.0) <= 1.0E-9) {
            re = 1.0;
        }
        if (Math.abs(re + 1.0) <= 1.0E-9) {
            re = -1.0;
        }
        return Complex.cart((double)re, (double)im);
    }

    private Polynomial(double[] coefficients) {
        this.coeff = coefficients;
    }

    public int degree() {
        return this.coeff.length - 1;
    }

    public DoubleSeq coefficients() {
        return DoubleSeq.of((double[])this.coeff);
    }

    public double[] toArray() {
        return (double[])this.coeff.clone();
    }

    public double get(int idx) {
        return this.coeff[idx];
    }

    public void copyTo(double[] buffer, int startpos) {
        System.arraycopy(this.coeff, 0, buffer, startpos, this.coeff.length);
    }

    public Polynomial derivate() {
        if (this.coeff.length == 1) {
            return ZERO;
        }
        int d = this.coeff.length - 1;
        double[] result = new double[d];
        for (int i = 1; i <= d; ++i) {
            result[i - 1] = (double)i * this.coeff[i];
        }
        return new Polynomial(result);
    }

    public Polynomial integrate() {
        double[] c = new double[this.coeff.length + 1];
        for (int i = 1; i <= this.coeff.length; ++i) {
            c[i] = this.coeff[i - 1] / (double)i;
        }
        return new Polynomial(c);
    }

    public double integrate(double a, double b) {
        Polynomial integral = this.integrate();
        return integral.evaluateAt(b) - integral.evaluateAt(a);
    }

    public double l2(double a, double b) {
        Polynomial q2 = this.times(this);
        return Math.sqrt(q2.integrate(a, b));
    }

    public Polynomial divide(double d) {
        return this.times(1.0 / d);
    }

    public Polynomial divide(Polynomial r) {
        return Polynomial.ofInternal(Polynomials.divide(this.coeff, r.coeff));
    }

    public boolean equals(Object obj) {
        return obj instanceof Polynomial ? this.equals((Polynomial)obj, 1.0E-9) : false;
    }

    public boolean equals(Polynomial other, double epsilon) {
        if (this == other) {
            return true;
        }
        if (this.coeff.length != other.coeff.length) {
            return false;
        }
        for (int i = 0; i < this.coeff.length; ++i) {
            if (DoubleSeq.equals((double)this.get(i), (double)other.get(i), (double)epsilon)) continue;
            return false;
        }
        return true;
    }

    public Complex evaluateAt(Complex x) {
        int i = this.coeff.length - 1;
        double xr = x.getRe();
        double xi = x.getIm();
        double fr2 = this.get(i--);
        double fi = 0.0;
        while (i >= 0) {
            double tr = fr2 * xr - fi * xi + this.get(i);
            double ti = fr2 * xi + fi * xr;
            fr2 = tr;
            fi = ti;
            --i;
        }
        return Complex.cart((double)fr2, (double)fi);
    }

    public double evaluateAt(double x) {
        int i = this.coeff.length - 1;
        double f = this.get(i--);
        while (i >= 0) {
            f = this.coeff[i] + f * x;
            --i;
        }
        return f;
    }

    public static double reverseEvaluate(double[] c, double x) {
        int d = c.length;
        int p = 0;
        double y = c[p++];
        while (p < d) {
            y = c[p] + y * x;
            ++p;
        }
        return y;
    }

    public Complex evaluateAtFrequency(double w) {
        ComplexComputer f = new ComplexComputer(this.get(0));
        for (int i = 1; i < this.coeff.length; ++i) {
            f.add((ComplexType)Complex.polar((double)this.coeff[i], (double)(w * (double)i)));
        }
        return f.result();
    }

    public int hashCode() {
        return Arrays.hashCode(this.coeff);
    }

    public boolean isZero() {
        return this.coeff.length == 1 && this.coeff[0] == 0.0;
    }

    public boolean isIdentity() {
        return this.coeff.length == 1 && this.coeff[0] == 1.0;
    }

    public Polynomial minus(double d) {
        return this.plus(-d);
    }

    public Polynomial minus(Polynomial r, boolean simplify) {
        double[] result = Polynomials.minus(this.coeff, r.coeff);
        return simplify ? new Polynomial(Coefficients.ofInternal(result)) : new Polynomial(result);
    }

    public Polynomial minus(Polynomial r) {
        return this.minus(r, this.degree() == r.degree());
    }

    public Polynomial mirror() {
        if (this.coeff.length == 1) {
            return this;
        }
        double[] result = new double[this.coeff.length];
        int i = 0;
        int j = this.coeff.length - 1;
        while (i < this.coeff.length) {
            result[i] = this.coeff[j];
            ++i;
            --j;
        }
        return new Polynomial(Coefficients.ofInternal(result));
    }

    public Polynomial rawMirror() {
        if (this.coeff.length == 1) {
            return this;
        }
        double[] result = new double[this.coeff.length];
        int i = 0;
        int j = this.coeff.length - 1;
        while (i < this.coeff.length) {
            result[i] = this.coeff[j];
            ++i;
            --j;
        }
        return new Polynomial(result);
    }

    public Polynomial negate() {
        return this.times(-1.0);
    }

    public Polynomial plus(double d) {
        if (d == 0.0) {
            return this;
        }
        double[] result = this.coefficients().toArray();
        result[0] = result[0] + d;
        return new Polynomial(result);
    }

    public Polynomial plus(Polynomial r) {
        if (r.isZero()) {
            return this;
        }
        double[] result = Polynomials.plus(this.coeff, r.coeff);
        return new Polynomial(Coefficients.ofInternal(result));
    }

    public Complex[] roots() {
        Complex[] result = this.defRoots.get();
        if (result == null) {
            result = this.roots(RootsSolver.fastSolver());
            this.defRoots.set(result);
        }
        return (Complex[])result.clone();
    }

    void setRoots(Complex[] roots) {
        this.defRoots.set(roots);
    }

    public Complex[] roots(RootsSolver solver) {
        if (this.coeff.length == 1) {
            return new Complex[0];
        }
        if (solver == null) {
            solver = RootsSolver.fastSolver();
        }
        if (solver.factorize(this)) {
            Complex[] roots = solver.roots();
            return roots;
        }
        return null;
    }

    public Polynomial smooth() {
        double[] result = this.coefficients().toArray();
        for (int i = 0; i < result.length; ++i) {
            double c = Math.round(result[i]);
            if (!DoubleSeq.equals((double)c, (double)result[i], (double)1.0E-9)) continue;
            result[i] = c;
        }
        return new Polynomial(Coefficients.ofInternal(result));
    }

    public Polynomial times(double d) {
        if (d == 0.0 || this.isZero()) {
            return ZERO;
        }
        if (d == 1.0) {
            return this;
        }
        double[] c = new double[this.coeff.length];
        for (int i = 0; i < c.length; ++i) {
            c[i] = d * this.coeff[i];
        }
        Polynomial result = new Polynomial(c);
        result.defRoots.set(this.defRoots.get());
        return result;
    }

    public Polynomial times(Polynomial r) {
        return this.times(r, false);
    }

    public Polynomial times(Polynomial r, boolean computeroots) {
        if (r.isZero() || this.isZero()) {
            return ZERO;
        }
        if (r.isIdentity()) {
            return this;
        }
        if (this.isIdentity()) {
            return r;
        }
        double[] result = Polynomials.times(this.coeff, r.coeff);
        Polynomial prod = new Polynomial(result);
        Object[] lRoots = this.defRoots.get();
        Object[] rRoots = r.defRoots.get();
        if (lRoots != null && rRoots != null) {
            prod.defRoots.set((Complex[])Arrays2.concat((Object[])lRoots, (Object[])rRoots));
        } else if (computeroots) {
            prod.defRoots.set((Complex[])Arrays2.concat((Object[])this.roots(), (Object[])r.roots()));
        }
        return prod;
    }

    public String toString() {
        return this.toString('X', true);
    }

    public String toString(char var, boolean bSmooth) {
        return this.toString("%6g", var, bSmooth);
    }

    public String toString(String fmt, char var, boolean bSmooth) {
        Polynomial p = bSmooth ? this.smooth() : this;
        StringBuilder sb = new StringBuilder(512);
        boolean sign = false;
        int n = p.degree();
        if (n == 0) {
            sb.append(new Formatter(Locale.ROOT).format(fmt, p.get(0)));
        } else {
            for (int i = 0; i <= n; ++i) {
                double v = Math.abs(p.get(i));
                if (!(v >= 1.0E-6)) continue;
                if (v > p.get(i)) {
                    sb.append(" - ");
                } else if (sign) {
                    sb.append(" + ");
                }
                if (v != 1.0 || i == 0) {
                    sb.append(new Formatter(Locale.ROOT).format(fmt, v).toString());
                }
                sign = true;
                if (i > 0) {
                    sb.append(' ').append(var);
                }
                if (i <= 1) continue;
                sb.append('^').append(i);
            }
        }
        return sb.toString();
    }

    public static Division divide(Polynomial num, Polynomial denom) {
        int n = num.degree();
        int nv = denom.degree();
        if (nv > n) {
            return new Division(num, ZERO);
        }
        double[] r = new double[n + 1];
        double[] q = new double[n + 1];
        for (int j = 0; j <= n; ++j) {
            r[j] = num.get(j);
            q[j] = 0.0;
        }
        for (int k = n - nv; k >= 0; --k) {
            q[k] = r[nv + k] / denom.get(nv);
            for (int j = nv + k - 1; j >= k; --j) {
                int n2 = j;
                r[n2] = r[n2] - q[k] * denom.get(j - k);
            }
        }
        Polynomial m_q = new Polynomial(Arrays.copyOf(q, n - nv + 1));
        Polynomial m_r = nv > 0 ? new Polynomial(Coefficients.ofInternal(Arrays.copyOf(r, nv))) : ZERO;
        return new Division(m_r, m_q);
    }

    public static Complex[] checkRoots(Complex[] roots) throws PolynomialException {
        int i;
        int nroots = roots.length;
        Complex[] rootsc = new Complex[nroots];
        boolean[] used = new boolean[nroots];
        for (i = 0; i < nroots; ++i) {
            roots[i] = Polynomial.smooth(roots[i]);
        }
        int j = 0;
        for (i = 0; i < nroots; ++i) {
            int k;
            if (used[i]) continue;
            Complex c = roots[i];
            if (c.getIm() == 0.0) {
                rootsc[j++] = c;
                used[i] = true;
                continue;
            }
            if (!(c.getIm() > 0.0)) continue;
            used[i] = true;
            Complex conj = c.conj();
            for (k = 0; k < nroots; ++k) {
                if (used[k] || !(roots[k].getIm() < 0.0) || !roots[k].equals(conj, 1.0E-9)) continue;
                used[k] = true;
                c = Complex.cart((double)((c.getRe() + roots[k].getRe()) / 2.0), (double)((c.getIm() - roots[k].getIm()) / 2.0));
                conj = c.conj();
                break;
            }
            if (k == nroots) {
                throw new PolynomialException("p_err_conj");
            }
            rootsc[j++] = c;
            rootsc[j++] = conj;
        }
        return rootsc;
    }

    public static final class Division {
        private final Polynomial m_r;
        private final Polynomial m_q;

        private Division(Polynomial remainder, Polynomial quotient) {
            this.m_r = remainder;
            this.m_q = quotient;
        }

        public Polynomial getQuotient() {
            return this.m_q;
        }

        public Polynomial getRemainder() {
            return this.m_r;
        }

        public boolean isExact() {
            return this.m_r.isZero();
        }
    }

    public static class SimplifyingTool
    extends Simplifying<Polynomial> {
        @Override
        public boolean simplify(Polynomial left, Polynomial right) {
            this.clear();
            this.common = ONE;
            if (left.coeff.length >= right.coeff.length) {
                this.simplify(left, right, null);
            } else {
                this.simplify(right, left, null);
                Polynomial tmp = (Polynomial)this.simplifiedLeft;
                this.simplifiedLeft = this.simplifiedRight;
                this.simplifiedRight = tmp;
            }
            return ((Polynomial)this.common).coeff.length > 1;
        }

        private boolean simplify(Polynomial left, Polynomial right, Complex[] roots) {
            if (right.coeff.length == 1) {
                return false;
            }
            if (this.simplifyExact(left, right)) {
                return true;
            }
            if (roots == null) {
                roots = right.roots();
            }
            double[] rtmp = Coefficients.fromDegree(1);
            double[] ctmp = Coefficients.fromDegree(2);
            for (Complex element : roots) {
                double[] xxx;
                if (!(left.evaluateAt(element).abs() < 1.0E-12)) continue;
                double a = element.getRe();
                double b = element.getIm();
                if (b == 0.0) {
                    rtmp[0] = -a;
                    xxx = Polynomials.divide(left.coeff, rtmp);
                    this.common = new Polynomial(Polynomials.times(((Polynomial)this.common).coeff, xxx));
                } else if (b > 0.0) {
                    ctmp[0] = a * a + b * b;
                    ctmp[1] = -2.0 * a;
                }
                xxx = Polynomials.divide(left.coeff, ctmp);
                this.common = new Polynomial(Polynomials.times(((Polynomial)this.common).coeff, xxx));
            }
            if (((Polynomial)this.common).degree() > 0) {
                this.simplifiedLeft = left;
                this.simplifiedRight = right.divide((Polynomial)this.common);
                return true;
            }
            return false;
        }

        @Override
        public boolean simplify(Polynomial left, UnitRoots right) {
            this.clear();
            this.common = ONE;
            return this.simplify(left, right.asPolynomial(), right.roots());
        }

        private boolean simplifyExact(Polynomial left, Polynomial right) {
            LeastSquaresDivision div = new LeastSquaresDivision();
            if (!div.divide(left, right) || !div.isExact()) {
                return false;
            }
            this.simplifiedLeft = div.getQuotient();
            this.simplifiedRight = ONE;
            this.common = right;
            return true;
        }
    }
}

