/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.arima.estimation;

import internal.toolkit.base.core.arima.AnsleyFilter;
import internal.toolkit.base.core.arima.KalmanFilter;
import internal.toolkit.base.core.arima.LjungBoxFilter;
import internal.toolkit.base.core.arima.ModifiedLjungBoxFilter;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.core.arima.IArimaModel;
import jdplus.toolkit.base.core.data.DataBlock;

public interface ArmaFilter {
    public void apply(DoubleSeq var1, DataBlock var2);

    public double getLogDeterminant();

    public int prepare(IArimaModel var1, int var2);

    public static ArmaFilter ansley() {
        return new AnsleyFilter();
    }

    @Deprecated
    public static ArmaFilter kalman() {
        return new KalmanFilter();
    }

    public static ArmaFilter kalman(boolean multiuse) {
        return new KalmanFilter(multiuse);
    }

    public static ArmaFilter ljungBox(boolean modified) {
        return modified ? new ModifiedLjungBoxFilter() : new LjungBoxFilter();
    }
}

