% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/harmonize_var_names.R
\name{harmonize_var_names}
\alias{harmonize_var_names}
\title{Harmonize the variable names of surveys}
\usage{
harmonize_var_names(
  survey_list,
  metadata,
  old = "var_name_orig",
  new = "var_name_suggested",
  rowids = TRUE
)
}
\arguments{
\item{survey_list}{A list of surveys imported with \code{\link{read_surveys}}}

\item{metadata}{A metadata table created by \code{metadata_create} and binded together for
all surveys in \code{survey_list}.}

\item{old}{The column name in \code{metadata} that contains the old, not harmonized variable names.}

\item{new}{The column name in \code{metadata} that contains the new, harmonized variable names.}

\item{rowids}{Rename var labels of original vars \code{rowid} to simply \code{uniqid}?}
}
\value{
The list of surveys with harmonized variable names.
}
\description{
The function harmonizes the variable names of surveys (of class \code{survey}) that
are imported from an external file as a wave.
}
\details{
If the \code{metadata} that contains subsetting information is subsetted, then
it will subset the surveys in
\code{survey_list}.
}
\examples{
examples_dir <- system.file("examples", package = "retroharmonize")
survey_list <- dir(examples_dir)[grepl("\\\\.rds", dir(examples_dir))]

example_surveys <- read_surveys(
  file.path(examples_dir, survey_list)
)

metadata <- metadata_create(example_surveys)
metadata$var_name_suggested <- label_normalize(metadata$var_name)
metadata$var_name_suggested[metadata$label_orig == "age_education"] <- "age_education"

harmonize_var_names(
  survey_list = example_surveys,
  metadata = metadata
)
}
\seealso{
crosswalk

Other harmonization functions: 
\code{\link{collect_val_labels}()},
\code{\link{crosswalk_surveys}()},
\code{\link{harmonize_na_values}()},
\code{\link{harmonize_survey_values}()},
\code{\link{harmonize_values}()},
\code{\link{is.crosswalk_table}()},
\code{\link{label_normalize}()}
}
\concept{harmonization functions}
