# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

compute_not_clusters <- function(clusters, col_type) {
    .Call(`_representr_compute_not_clusters`, clusters, col_type)
}

#' dist_col_type
#' Inner column type record distance function
#'
#' @param a record a
#' @param b record b
#' @param col_type A vector encoding the column type for each column in the dataset. Can take values
#' in "categorical", "ordinal", "string", or "numeric"
#' @param weights A vector of weights for each column for making some column distances more important. Must sum to 1.
#' Defaults to equal weights.
#' @param orders A named list containing the order of the levels in each ordinal column. Defaults to NULL,
#' which corresponds to no ordinal variables.
#' @export
dist_col_type <- function(a, b, col_type, weights, orders) {
    .Call(`_representr_dist_col_type`, a, b, col_type, weights, orders)
}

#' levenshtein
#' Internal String distance functions
#'
#' @param str1 string 1
#' @param str2 string 2.
NULL

#'
#' @references {
#'   M. E., Macherki (2016): Algorithm:Levenshtein Rcpp. figshare. Software. https://doi.org/10.6084/m9.figshare.3386308.v1
#' }
levenshtein <- function(str1, str2) {
    .Call(`_representr_levenshtein`, str1, str2)
}

#' within_category_compare_cpp
#' Inner column type record distance function
#'
#' @param ties A data frame of the records that are tied
#' @param not_cluster A data frame of the records outside the cluster
#' @param col_type A vector encoding the column type for each column in the dataset. Can take values
#' in "categorical", "ordinal", "string", or "numeric"
#' @param weights A vector of weights for each column for making some column distances more important. Must sum to 1.
#' Defaults to equal weights.
#' @param orders A named list containing the order of the levels in each ordinal column. Defaults to NULL,
#' which corresponds to no ordinal variables.
#' @param distance function that does nothing right now, but must be supplied to not break other code.
#' @export
within_category_compare_cpp <- function(ties, not_cluster, col_type, weights, orders, distance) {
    .Call(`_representr_within_category_compare_cpp`, ties, not_cluster, col_type, weights, orders, distance)
}

