% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lag.R
\name{step_lag}
\alias{step_lag}
\title{Create a lagged predictor}
\usage{
step_lag(
  recipe,
  ...,
  role = "predictor",
  trained = FALSE,
  lag = 1,
  prefix = "lag_",
  default = NA,
  columns = NULL,
  keep_original_cols = TRUE,
  skip = FALSE,
  id = rand_id("lag")
)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the sequence of
operations for this recipe.}

\item{...}{One or more selector functions to choose variables for this step.
See \code{\link[=selections]{selections()}} for more details.}

\item{role}{For model terms created by this step, what analysis role should
they be assigned? By default, the new columns created by this step from the
original variables will be used as \emph{predictors} in a model.}

\item{trained}{A logical to indicate if the quantities for preprocessing have
been estimated.}

\item{lag}{A vector of positive integers. Each specified column will be
lagged for each value in the vector.}

\item{prefix}{A prefix for generated column names, default to \code{"lag_"}.}

\item{default}{Passed to \code{\link[dplyr:lead-lag]{dplyr::lag()}}, determines what fills empty rows
left by lagging (defaults to NA).}

\item{columns}{A character string of the selected variable names. This field
is a placeholder and will be populated once \code{\link[=prep]{prep()}} is used.}

\item{keep_original_cols}{A logical to keep the original variables in the
output. Defaults to \code{TRUE}.}

\item{skip}{A logical. Should the step be skipped when the recipe is baked by
\code{\link[=bake]{bake()}}? While all operations are baked when \code{\link[=prep]{prep()}} is run, some
operations may not be able to be conducted on new data (e.g. processing the
outcome variable(s)). Care should be taken when using \code{skip = TRUE} as it
may affect the computations for subsequent operations.}

\item{id}{A character string that is unique to this step to identify it.}
}
\value{
An updated version of \code{recipe} with the new step added to the
sequence of any existing operations.
}
\description{
\code{step_lag()} creates a \emph{specification} of a recipe step that will add new
columns of lagged data. Lagged data will by default include NA values where
the lag was induced. These can be removed with \code{\link[=step_naomit]{step_naomit()}}, or you may
specify an alternative filler value with the \code{default} argument.
}
\details{
The step assumes that the data are already \emph{in the proper sequential order}
for lagging.
}
\section{Tidying}{
When you \code{\link[=tidy.recipe]{tidy()}} this step, a tibble is returned with
columns \code{terms} and \code{id}:

\describe{
\item{terms}{character, the selectors or variables selected}
\item{id}{character, id of this step}
}
}

\section{Sparse data}{


This step can be applied to \link{sparse_data} such that it is preserved. Nothing
needs to be done for this to happen as it is done automatically.
}

\section{Case weights}{


The underlying operation does not allow for case weights.
}

\examples{
n <- 10
start <- as.Date("1999/01/01")
end <- as.Date("1999/01/10")

df <- data.frame(
  x = runif(n),
  index = 1:n,
  day = seq(start, end, by = "day")
)

recipe(~., data = df) |>
  step_lag(index, day, lag = 2:3) |>
  prep(df) |>
  bake(df)
}
\seealso{
Other row operation steps: 
\code{\link{step_arrange}()},
\code{\link{step_filter}()},
\code{\link{step_impute_roll}()},
\code{\link{step_naomit}()},
\code{\link{step_sample}()},
\code{\link{step_shuffle}()},
\code{\link{step_slice}()}
}
\concept{row operation steps}
