% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createIndex.R
\name{createIndex}
\alias{createIndex}
\title{Create file and meta index of the DWD CDC FTP Server}
\usage{
createIndex(
  paths,
  base = dwdbase,
  dir = locdir(),
  fname = "fileIndex.txt",
  meta = FALSE,
  metadir = "meta",
  mname = "metaIndex.txt",
  gname = "geoIndex.txt",
  overwrite = FALSE,
  check = TRUE,
  checkwarn = TRUE,
  checklog = tempfile(),
  quiet = rdwdquiet(),
  ...
)
}
\arguments{
\item{paths}{Char: vector of DWD paths returned by \code{\link[=indexFTP]{indexFTP()}} called
with the same \code{base} value as this function}

\item{base}{Main directory of DWD ftp server, defaulting to observed climatic records.
DEFAULT: \code{\link{dwdbase}}}

\item{dir}{Char: writeable directory name where to save the main output(s).
Created if not existent. DEFAULT: \code{\link[=locdir]{locdir()}}}

\item{fname}{Char: Name of file in \code{dir} in which to write \code{\link{fileIndex}}.
Use \code{fname=""} to suppress writing. DEFAULT: "fileIndex.txt"}

\item{meta}{Logical: should metaIndex also be created from fileIndex?
Uses \code{\link[=dataDWD]{dataDWD()}} to download files if not present.
DEFAULT: FALSE}

\item{metadir}{Char: Directory (subfolder of \code{dir}) where original
description files are downloaded to if meta=TRUE. Passed to
\code{\link[=dataDWD]{dataDWD()}}. "" to write in \code{dir}. DEFAULT: "meta"}

\item{mname}{Char: Name of file in \code{dir} (not \code{metadir}) in which to
write \code{\link{metaIndex}}.
Use \code{mname=""} to suppress writing. DEFAULT: "metaIndex.txt"}

\item{gname}{Filename for \code{\link{geoIndex}}. DEFAULT: "geoIndex.txt"}

\item{overwrite}{Logical: Overwrite existing \code{fname / mname / gname} files?
If not, "_n" is added to the filenames, see
\code{\link[berryFunctions:newFilename]{berryFunctions::newFilename()}}.
DEFAULT: FALSE}

\item{check}{Logical: run \code{\link[=checkIndex]{checkIndex()}}? DEFAULT: TRUE}

\item{checkwarn}{Logical: warn about \code{\link[=checkIndex]{checkIndex()}} issues? DEFAULT: TRUE}

\item{checklog}{Logfile for \code{\link[=checkIndex]{checkIndex()}}. DEFAULT: \code{\link[=tempfile]{tempfile()}}}

\item{quiet}{Logical: Suppress messages about progress and filenames?
DEFAULT: FALSE through \code{\link[=rdwdquiet]{rdwdquiet()}}}

\item{\dots}{Further arguments passed to \code{\link[=dataDWD]{dataDWD()}} for the meta part.}
}
\value{
invisible data.frame (or if meta=TRUE, list with two data.frames)
with a number of columns inferred from the paths. Each is also written to disc.
}
\description{
This is mainly an internal function.
Create data.frames out of the vector index returned by \code{\link[=indexFTP]{indexFTP()}}.
For \code{\link{fileIndex}} (the first output element) \code{createIndex}
tries to obtain res, var, per, file, id, start and end from the paths.
If \code{meta=TRUE}, \code{\link{metaIndex}} and \code{\link{geoIndex}} are also
created. They combine all Beschreibung files into a single data.frame.\cr
If you create your own index as suggested in selectDWD (argument \code{findex}),
you can read the produced file as shown in the example section.
}
\examples{
\dontrun{ # Not tested with R CMD check because of file writing
link <- "daily/kl/historical/tageswerte_KL_00699_19490101_19580630_hist.zip"
ind <- createIndex(link, dir=tempdir())
ind
# res  var        per  id    start          end ismeta
# daily kl historical 699 1949-01-01 1958-06-30 FALSE
link2 <- "daily/kl/historical/KL_Tageswerte_Beschreibung_Stationen.txt"
link3 <- "daily/kl/recent/KL_Tageswerte_Beschreibung_Stationen.txt"
ind2 <- createIndex(c(link,link2,link3), dir=tempdir(), meta=TRUE, checkwarn=FALSE)
lapply(ind2, head)
link4 <- "1_minute/precipitation/meta_data/Meta_Daten_ein_min_rr_00755.zip"
ind <- createIndex(link4, dir=tempdir())
ind
}

}
\seealso{
\code{\link[=indexFTP]{indexFTP()}}, \code{\link[=updateIndexes]{updateIndexes()}}, \code{\link{index}}, \code{\link[=selectDWD]{selectDWD()}},
\href{https://brry.github.io/rdwd/fileindex.html}{website index chapter}
}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, Oct-Nov 2016, June 2017
}
\keyword{manip}
