% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covarTests.R
\name{covarTest_mean}
\alias{covarTest_mean}
\alias{covarTest_mean.rdd_data}
\alias{covarTest_mean.rdd_reg}
\title{Testing for balanced covariates: equality of means with t-test}
\usage{
covarTest_mean(
  object,
  bw = NULL,
  paired = FALSE,
  var.equal = FALSE,
  p.adjust = c("none", "holm", "BH", "BY", "hochberg", "hommel", "bonferroni")
)

\method{covarTest_mean}{rdd_data}(
  object,
  bw = NULL,
  paired = FALSE,
  var.equal = FALSE,
  p.adjust = c("none", "holm", "BH", "BY", "hochberg", "hommel", "bonferroni")
)

\method{covarTest_mean}{rdd_reg}(
  object,
  bw = NULL,
  paired = FALSE,
  var.equal = FALSE,
  p.adjust = c("none", "holm", "BH", "BY", "hochberg", "hommel", "bonferroni")
)
}
\arguments{
\item{object}{object of class rdd_data}

\item{bw}{a bandwidth}

\item{paired}{Argument of the \code{\link{t.test}} function: logical indicating whether you want paired t-tests.}

\item{var.equal}{Argument of the \code{\link{t.test}} function:  logical variable indicating whether to treat the two variances as being equal}

\item{p.adjust}{Whether to adjust the p-values for multiple testing. Uses the \code{\link{p.adjust}} function}
}
\value{
A data frame with, for each covariate, the mean on each size, the difference, t-stat and ts p-value.
}
\description{
Tests equality of means by a t-test for each covariate, between the two full groups or around the discontinuity threshold
}
\examples{
data(house)

## Add randomly generated covariates
set.seed(123)
n_Lee <- nrow(house)
Z <- data.frame(z1 = rnorm(n_Lee, sd=2), 
                z2 = rnorm(n_Lee, mean = ifelse(house<0, 5, 8)), 
                z3 = sample(letters, size = n_Lee, replace = TRUE))
house_rdd_Z <- rdd_data(y = house$y, x = house$x, covar = Z, cutpoint = 0)

## test for equality of means around cutoff:
covarTest_mean(house_rdd_Z, bw=0.3)

## Can also use function covarTest_dis() for Kolmogorov-Smirnov test:
covarTest_dis(house_rdd_Z, bw=0.3)

## covarTest_mean works also on regression outputs (bw will be taken from the model)
reg_nonpara <- rdd_reg_np(rdd_object=house_rdd_Z)
covarTest_mean(reg_nonpara)
}
\seealso{
\code{\link{covarTest_dis}} for the Kolmogorov-Smirnov test of equality of distribution
}
\author{
Matthieu Stigler <\email{Matthieu.Stigler@gmail.com}>
}
