% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fractional.operators.R
\name{spde.matern.operators}
\alias{spde.matern.operators}
\title{Rational approximations of non-stationary Gaussian SPDE Matern random fields}
\usage{
spde.matern.operators(
  kappa = NULL,
  tau = NULL,
  theta = NULL,
  B.tau = matrix(c(0, 1, 0), 1, 3),
  B.kappa = matrix(c(0, 0, 1), 1, 3),
  B.sigma = matrix(c(0, 1, 0), 1, 3),
  B.range = matrix(c(0, 0, 1), 1, 3),
  alpha = NULL,
  nu = NULL,
  parameterization = c("spde", "matern"),
  G = NULL,
  C = NULL,
  d = NULL,
  graph = NULL,
  mesh = NULL,
  range_mesh = NULL,
  loc_mesh = NULL,
  m = 1,
  type = c("covariance", "operator"),
  type_rational_approximation = c("brasil", "chebfun", "chebfunLB")
)
}
\arguments{
\item{kappa}{Vector with the, possibly spatially varying, range parameter
evaluated at the locations of the mesh used for the finite element
discretization of the SPDE.}

\item{tau}{Vector with the, possibly spatially varying, precision
parameter evaluated at the locations
of the mesh used for the finite element discretization of the SPDE.}

\item{theta}{Theta parameter that connects B.tau and B.kappa to tau and kappa through a log-linear regression, in case the parameterization is \code{spde},
and that connects B.sigma and B.range to tau and kappa in case the parameterization is \code{matern}. When both tau and kappa are constant after this
transformation, \code{spde.matern.operators()} delegates to \code{matern.operators()}.}

\item{B.tau}{Matrix with specification of log-linear model for \eqn{\tau}. Will be used if \code{parameterization = 'spde'}.}

\item{B.kappa}{Matrix with specification of log-linear model for \eqn{\kappa}. Will be used if \code{parameterization = 'spde'}.}

\item{B.sigma}{Matrix with specification of log-linear model for \eqn{\sigma}. Will be used if \code{parameterization = 'matern'}.}

\item{B.range}{Matrix with specification of log-linear model for \eqn{\rho}, which is a range-like parameter (it is exactly the range parameter in the stationary case). Will be used if \code{parameterization = 'matern'}.}

\item{alpha}{smoothness parameter. Will be used if the parameterization is 'spde'.}

\item{nu}{Shape parameter of the covariance function. Will be used if the parameterization is 'matern'.}

\item{parameterization}{Which parameterization to use? \code{matern} uses range, std. deviation and nu (smoothness). \code{spde} uses kappa, tau and nu (smoothness). The default is \code{matern}.}

\item{G}{The stiffness matrix of a finite element discretization of
the domain of interest.}

\item{C}{The mass matrix of a finite element discretization of the
domain of interest.}

\item{d}{The dimension of the domain. Does not need to be given if
\code{mesh} is used.}

\item{graph}{An optional \code{metric_graph} object. Replaces \code{d}, \code{C} and \code{G}.}

\item{mesh}{An optional inla mesh. \code{d}, \code{C} and \code{G}
must be given if \code{mesh} is not given.}

\item{range_mesh}{The range of the mesh. Will be used to provide starting values for the parameters. Will be used if \code{mesh} and \code{graph} are \code{NULL}, and if one of the parameters (kappa or tau for spde parameterization, or sigma or range for matern parameterization) are not provided.}

\item{loc_mesh}{The mesh locations used to construct the matrices C and G. This option should be provided if one wants to use the \code{rspde_lme()} function and will not provide neither graph nor mesh. Only works for 1d data. Does not work for metric graphs. For metric graphs you should supply the graph using the \code{graph} argument.}

\item{m}{The order of the rational approximation, which needs to be a
positive integer. The default value is 1.}

\item{type}{The type of the rational approximation. The options are
"covariance" and "operator". The default is "covariance".}

\item{type_rational_approximation}{Which type of rational
approximation should be used? The current types are
"brasil", "chebfun" or "chebfunLB".}
}
\value{
\code{spde.matern.operators} returns an object of
class "rSPDEobj. This object contains the
quantities listed in the output of \code{\link[=fractional.operators]{fractional.operators()}}
as well as the smoothness parameter \eqn{\nu}.
}
\description{
\code{spde.matern.operators} is used for computing a rational SPDE
approximation of a Gaussian random
fields on \eqn{R^d} defined as a solution to the SPDE
\deqn{(\kappa(s) - \Delta)^\beta (\tau(s)u(s)) = W.}
}
\details{
The approximation is based on a rational approximation of the
fractional operator \eqn{(\kappa(s)^2 -\Delta)^\beta}, where
\eqn{\beta = (\nu + d/2)/2}. This results in an approximate model
on the form \deqn{P_l u(s) = P_r W,} where \eqn{P_j = p_j(L)} are
non-fractional operators defined in terms of polynomials \eqn{p_j} for
\eqn{j=l,r}. The order of \eqn{p_r} is given by \code{m} and the order
of \eqn{p_l} is \eqn{m + m_\beta} where \eqn{m_\beta} is the integer
part of \eqn{\beta} if \eqn{\beta>1} and \eqn{m_\beta = 1} otherwise.

The discrete approximation can be written as \eqn{u = P_r x} where
\eqn{x \sim N(0,Q^{-1})}{x ~ N(0,Q^{-1})}
and \eqn{Q = P_l^T C^{-1} P_l}. Note that the matrices \eqn{P_r} and
\eqn{Q} may be be ill-conditioned for \eqn{m>1}.
In this case, the metehods in \code{\link[=operator.operations]{operator.operations()}}
should be used for operations involving the matrices, since
these methods are more numerically stable.
}
\examples{
# Sample non-stationary Matern field on R
tau <- 1
nu <- 0.8

# create mass and stiffness matrices for a FEM discretization
x <- seq(from = 0, to = 1, length.out = 101)
fem <- rSPDE.fem1d(x)

# define a non-stationary range parameter
kappa <- seq(from = 2, to = 20, length.out = length(x))
alpha <- nu + 1 / 2
# compute rational approximation
op <- spde.matern.operators(
  kappa = kappa, tau = tau, alpha = alpha,
  G = fem$G, C = fem$C, d = 1
)

# sample the field
u <- simulate(op)

# plot the sample
plot(x, u, type = "l", ylab = "u(s)", xlab = "s")

}
\seealso{
\code{\link[=fractional.operators]{fractional.operators()}},
\code{\link[=spde.matern.operators]{spde.matern.operators()}},
\code{\link[=matern.operators]{matern.operators()}}
}
