% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixed_binomial_enhanced.R
\name{qbrmb}
\alias{qbrmb}
\title{Enhanced binomial mixed-effects modelling}
\usage{
qbrmb(
  formula,
  data,
  family = "binomial",
  strategy = "auto",
  regularisation_strength = 0.1,
  use_data_augmentation = TRUE,
  min_group_size = 5,
  verbose = FALSE,
  diagnostics = FALSE,
  silent = FALSE,
  ...
)
}
\arguments{
\item{formula}{Model formula with random effects in lme4-style syntax.}

\item{data}{Data frame containing the variables in the model.}

\item{family}{Model family (currently \code{"binomial"} or \code{"bernoulli"};
default \code{"binomial"}).}

\item{strategy}{Fitting strategy: \code{"auto"}, \code{"enhanced"},
\code{"aggressive"}, or \code{"minimal"}.}

\item{regularisation_strength}{Regularisation strength in the interval
\eqn{[0, 1]} (default \code{0.1}).}

\item{use_data_augmentation}{Logical; if \code{TRUE}, add pseudo-observations
for additional numerical stability.}

\item{min_group_size}{Minimum group size before triggering diagnostic
warnings.}

\item{verbose}{Logical; if \code{TRUE}, show detailed progress and
diagnostics while fitting.}

\item{diagnostics}{Logical; if \code{TRUE}, compute and store extended
diagnostics in the returned object.}

\item{silent}{Logical; if \code{TRUE}, suppress printed output except
errors.}

\item{...}{Additional arguments passed to \code{INLA::inla()}.}
}
\value{
An object of class \code{c("qbrmb_fit", "qbrms_fit", "list")}
containing the fitted model, diagnostics and metadata.
}
\description{
Fits a regularised binomial (or Bernoulli) mixed-effects model using INLA,
with enhanced diagnostics, stability checks and strategy selection.
}
