% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prior_elicitation.R
\name{print.qbrms_prior_build}
\alias{print.qbrms_prior_build}
\title{Print method for qbrms_prior_build objects}
\usage{
\method{print}{qbrms_prior_build}(
  x,
  digits = 3,
  show_data = FALSE,
  show_code = TRUE,
  code_object_name = "priors",
  max_terms = 12,
  ...
)
}
\arguments{
\item{x}{An object of class \code{"qbrms_prior_build"} as returned by
\code{\link{prior_build_from_beliefs}}.}

\item{digits}{Integer scalar giving the number of decimal places to display
for numeric summaries (default: \code{3}).}

\item{show_data}{Logical; if \code{TRUE}, print a compact summary of the
elicitation data used to construct the priors.}

\item{show_code}{Logical; if \code{TRUE}, print the corresponding prior code
that can be copied into a modelling script.}

\item{code_object_name}{Character string giving the name that will be used
for the prior object in the displayed code (default: \code{"priors"}).}

\item{max_terms}{Integer scalar giving the maximum number of individual terms
to display before truncating the printed output (default: \code{12}).}

\item{...}{Currently ignored. Included for method compatibility.}
}
\value{
Invisibly returns the input object \code{x}.
}
\description{
Nicely formats the result of \code{prior_build_from_beliefs()}, showing the
elicited beliefs, implied prior distributions, and (optionally) the
corresponding prior code.
}
