% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_export.R
\name{export_model}
\alias{export_model}
\title{Export Model Specification}
\usage{
export_model(
  model,
  file,
  format = c("R", "markdown", "text", "json"),
  include_data = TRUE,
  include_diagnostics = FALSE
)
}
\arguments{
\item{model}{A fitted qbrms model object or qbrms_model_spec object}

\item{file}{Character string specifying output file path}

\item{format}{Character string specifying export format: "R" (R script),
"markdown" (Rmd document), "text" (plain text), or "json" (JSON format)}

\item{include_data}{Logical; if TRUE, includes data summary in export
(default: TRUE)}

\item{include_diagnostics}{Logical; if TRUE and model is fitted, includes
diagnostic information (default: FALSE)}
}
\value{
Invisibly returns the export content as a character string
}
\description{
Export model specifications to various formats for sharing, documentation,
or reproduction.
}
\details{
This function facilitates model sharing and documentation by exporting:
\itemize{
\item Model formula and family specification
\item Prior specifications (if any)
\item Data summary and structure
\item Model fitting code
\item Results summary (for fitted models)
\item Diagnostic information (if requested)
}

The exported content can be used to:
\itemize{
\item Share analyses with collaborators
\item Document modelling decisions
\item Create reproducible research reports
\item Archive model specifications
}
}
\examples{
\dontrun{
# Export model specification
spec <- model_builder(data = mtcars, response = "mpg")
export_model(spec, "my_model_spec.R", format = "R")

# Export fitted model
fit <- qbrms(mpg ~ hp + wt, data = mtcars, family = gaussian())
export_model(fit, "my_model.Rmd", format = "markdown", 
             include_diagnostics = TRUE)

# Export as JSON
export_model(spec, "my_model.json", format = "json")
}

}
