% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ProductPOSet.R
\name{ProductPOSet}
\alias{ProductPOSet}
\title{Constructing the product of posets.}
\usage{
ProductPOSet(poset1, poset2, ...)
}
\arguments{
\item{poset1}{An object of S4 class \code{POSet}.
Argument \code{poset1} must be created by using any function contained in the package
aimed at building object of S4 class \code{POSet}
(e.g. \code{\link[=POSet]{POSet()}}, \code{\link[=LinearPOSet]{LinearPOSet()}}, \code{\link[=ProductPOSet]{ProductPOSet()}}, ...) .}

\item{poset2}{An object of S4 class \code{POSet}.
Argument \code{poset2} must be created by using any function contained in the package
aimed at building object of S4 class \code{POSet}
(e.g. \code{\link[=POSet]{POSet()}}, \code{\link[=LinearPOSet]{LinearPOSet()}}, \code{\link[=ProductPOSet]{ProductPOSet()}}, ...) .}

\item{...}{Optional additional objects of S4 class \code{POSet}.
Optional arguments must be created by using any function contained in the package
aimed at building object of S4 class \code{POSet}
(e.g. \code{\link[=POSet]{POSet()}}, \code{\link[=LinearPOSet]{LinearPOSet()}}, \code{\link[=ProductPOSet]{ProductPOSet()}}, ...) .}
}
\value{
The product poset, an object of S4 class \code{ProductPOSet} (subclass of \code{POSet}).
}
\description{
Constructs the product poset \eqn{(V, \leq_{prd})}, starting from a collection of posets.
}
\details{
Let \eqn{P_1 = (V_1, \leq_1), ..., P_k = (V_k, \leq_k)} be a collection of posets.
The product poset \eqn{P=P_1 \times...\times P_k} is the poset \eqn{(V, \leq_{prd})} where
\eqn{V=V_1\times...\times V_k} and given \eqn{(a_1, ..., a_k)\in V}
and \eqn{(b_1, ..., b_k)\in V},  \eqn{(a_1, ..., a_k)\leq_{prd} (b_1, ..., b_k)} if and only if
\eqn{a_i\leq_i b_i} for all \eqn{i=1, ..., k}.
}
\examples{
elems1 <- c("a", "b", "c", "d")
elems2 <- c("x", "y", "z")
elems3 <- c("q", "r")

dom <- matrix(c(
  "a", "b",
  "c", "b",
  "b", "d"
), ncol = 2, byrow = TRUE)

p1 <- POSet(elements = elems1, dom = dom)
p2 <- LinearPOSet(elements = elems2)
p3 <- LinearPOSet(elements = elems3)

prd12 <- ProductPOSet(p1, p2)

prd123 <- ProductPOSet(p1, p2, p3)

}
