% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jitterplot.R
\name{JitterPlotAtomic}
\alias{JitterPlotAtomic}
\title{Atomic Jitter plot}
\usage{
JitterPlotAtomic(
  data,
  x,
  x_sep = "_",
  y = NULL,
  in_form = c("long", "wide"),
  keep_na = FALSE,
  keep_empty = FALSE,
  sort_x = c("none", "mean_asc", "mean_desc", "mean", "median_asc", "median_desc",
    "median"),
  flip = FALSE,
  group_by = NULL,
  group_by_sep = "_",
  group_name = NULL,
  x_text_angle = 0,
  order_by = "-({y}^2 + {size_by}^2)",
  theme = "theme_this",
  theme_args = list(),
  palette = "Paired",
  palcolor = NULL,
  alpha = 1,
  aspect.ratio = NULL,
  legend.position = "right",
  legend.direction = "vertical",
  shape = 21,
  border = "black",
  size_by = 2,
  size_name = NULL,
  size_trans = NULL,
  y_nbreaks = 4,
  jitter_width = 0.5,
  jitter_height = 0,
  y_max = NULL,
  y_min = NULL,
  y_trans = "identity",
  add_bg = FALSE,
  bg_palette = "stripe",
  bg_palcolor = NULL,
  bg_alpha = 0.2,
  add_hline = NULL,
  hline_type = "solid",
  hline_width = 0.5,
  hline_color = "black",
  hline_alpha = 1,
  labels = NULL,
  label_by = NULL,
  nlabel = 5,
  label_size = 3,
  label_fg = "black",
  label_bg = "white",
  label_bg_r = 0.1,
  highlight = NULL,
  highlight_color = "red2",
  highlight_size = 1,
  highlight_alpha = 1,
  facet_by = NULL,
  facet_scales = "fixed",
  facet_ncol = NULL,
  facet_nrow = NULL,
  facet_byrow = TRUE,
  title = NULL,
  subtitle = NULL,
  xlab = NULL,
  ylab = NULL,
  seed = 8525,
  ...
)
}
\arguments{
\item{data}{A data frame.}

\item{x}{A character string of the column name to plot on the x-axis.
A character/factor column is expected. If multiple columns are provided, the columns will be concatenated with \code{x_sep}.}

\item{x_sep}{A character string to concatenate the columns in \code{x}, if multiple columns are provided.
When \code{in_form} is "wide", \code{x} columns will not be concatenated.}

\item{y}{A character string of the column name to plot on the y-axis. A numeric column is expected.
When \code{in_form} is "wide", \code{y} is not required. The values under \code{x} columns will be used as y-values.}

\item{in_form}{A character string to specify the input data type. Either "long" or "wide".}

\item{keep_na}{A logical value or a character to replace the NA values in the data.
It can also take a named list to specify different behavior for different columns.
If TRUE or NA, NA values will be replaced with NA.
If FALSE, NA values will be removed from the data before plotting.
If a character string is provided, NA values will be replaced with the provided string.
If a named vector/list is provided, the names should be the column names to apply the behavior to,
and the values should be one of TRUE, FALSE, or a character string.
Without a named vector/list, the behavior applies to categorical/character columns used on the plot,
for example, the \code{x}, \code{group_by}, \code{fill_by}, etc.}

\item{keep_empty}{One of FALSE, TRUE and "level". It can also take a named list to specify
different behavior for different columns. Without a named list, the behavior applies to the
categorical/character columns used on the plot, for example, the \code{x}, \code{group_by}, \code{fill_by}, etc.
\itemize{
\item{\code{FALSE} (default): Drop empty factor levels from the data before plotting.}
\item{\code{TRUE}: Keep empty factor levels and show them as a separate category in the plot.}
\item{\code{"level"}: Keep empty factor levels, but do not show them in the plot.
But they will be assigned colors from the palette to maintain consistency across multiple plots.
Alias: \code{levels}}
}}

\item{sort_x}{A character string to specify the sorting of x-axis, chosen from "none", "mean_asc", "mean_desc", "mean", "median_asc", "median_desc", "median".
\itemize{
\item \code{none} means no sorting (as-is).
\item \code{mean_asc} sorts the x-axis by ascending mean of y-values.
\item \code{mean_desc} sorts the x-axis by descending mean of y-values.
\item \code{mean} is an alias for \code{mean_asc}.
\item \code{median_asc} sorts the x-axis by ascending median of y-values.
\item \code{median_desc} sorts the x-axis by descending median of y-values.
\item \code{median} is an alias for \code{median_asc}.
}}

\item{flip}{A logical value to flip the plot.}

\item{group_by}{A character string to dodge the points.}

\item{group_by_sep}{A character string to concatenate the columns in \code{group_by}, if multiple columns are provided.}

\item{group_name}{A character string to name the legend of dodge.}

\item{x_text_angle}{A numeric value specifying the angle of the x-axis text.}

\item{order_by}{A string of expression passed to \code{dplyr::arrange()} to order the data to get the
top \code{nlabel} points for labeling. Default is \code{-({y}^2 + {size_by}^2)} (similar to VolcanoPlot).}

\item{theme}{A character string or a theme class (i.e. ggplot2::theme_classic) specifying the theme to use.
Default is "theme_this".}

\item{theme_args}{A list of arguments to pass to the theme function.}

\item{palette}{A character string specifying the palette to use.
A named list or vector can be used to specify the palettes for different \code{split_by} values.}

\item{palcolor}{A character string specifying the color to use in the palette.
A named list can be used to specify the colors for different \code{split_by} values.
If some values are missing, the values from the palette will be used (palcolor will be NULL for those values).}

\item{alpha}{Point transparency.}

\item{aspect.ratio}{A numeric value specifying the aspect ratio of the plot.}

\item{legend.position}{A character string specifying the position of the legend.
if \code{waiver()}, for single groups, the legend will be "none", otherwise "right".}

\item{legend.direction}{A character string specifying the direction of the legend.}

\item{shape}{A numeric value to specify the point shape.
Shapes 21–25 have borders; border behavior is controlled by \code{border}.}

\item{border}{A logical or character value to specify the border of points when the shape has border (21–25).
If TRUE, border color follows the point color (same as fill). If a color string, uses that constant border color.
If FALSE, no border.}

\item{size_by}{A numeric column name or a single numeric value for the point size.
When a column, sizes are scaled (see scatter plots).}

\item{size_name}{Legend title for size when \code{size_by} is a column.}

\item{size_trans}{A function or a name of a global function to transform \code{size_by} (when \code{size_by} is a column).
The legend shows original (untransformed) values.}

\item{jitter_width, jitter_height}{Jitter parameters.}

\item{y_max, y_min}{Numeric or quantile strings ("q95", "q5") for y limits computation (used for fixed coord).}

\item{y_trans, y_nbreaks}{Axis settings.}

\item{add_bg}{A logical value to add background to the plot.}

\item{bg_palette}{A character string to specify the palette of the background.}

\item{bg_palcolor}{A character vector to specify the colors of the background.}

\item{bg_alpha}{A numeric value to specify the transparency of the background.}

\item{add_hline}{Add one or more horizontal reference lines at the given y-value(s).}

\item{hline_type}{The line type for the horizontal reference line(s).}

\item{hline_width}{The line width for the horizontal reference line(s).}

\item{hline_color}{The color for the horizontal reference line(s).}

\item{hline_alpha}{The alpha for the horizontal reference line(s).}

\item{labels}{A vector of row names or indices to label the points.}

\item{label_by}{A character column name to use as the label text. If NULL, rownames are used.}

\item{nlabel}{Number of points to label per x-group when \code{labels} is NULL (top by y^2 + size^2).}

\item{label_size, label_fg, label_bg, label_bg_r}{Label aesthetics.}

\item{highlight, highlight_color, highlight_size, highlight_alpha}{Highlighted point options.}

\item{facet_by}{A character string specifying the column name of the data frame to facet the plot.
Otherwise, the data will be split by \code{split_by} and generate multiple plots
and combine them into one using \code{patchwork::wrap_plots}}

\item{facet_scales}{Whether to scale the axes of facets. Default is "fixed"
Other options are "free", "free_x", "free_y". See \code{ggplot2::facet_wrap}}

\item{facet_ncol}{A numeric value specifying the number of columns in the facet.
When facet_by is a single column and facet_wrap is used.}

\item{facet_nrow}{A numeric value specifying the number of rows in the facet.
When facet_by is a single column and facet_wrap is used.}

\item{facet_byrow}{A logical value indicating whether to fill the plots by row. Default is TRUE.}

\item{title}{A character string specifying the title of the plot.
A function can be used to generate the title based on the default title.
This is useful when split_by is used and the title needs to be dynamic.}

\item{subtitle}{A character string specifying the subtitle of the plot.}

\item{xlab}{A character string specifying the x-axis label.}

\item{ylab}{A character string specifying the y-axis label.}

\item{seed}{The random seed to use. Default is 8525.}

\item{...}{Additional arguments.}
}
\value{
A ggplot object
}
\description{
Atomic Jitter plot
}
\keyword{internal}
