% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotSEMM_contour.R
\name{plotSEMM_contour}
\alias{plotSEMM_contour}
\title{Nonlinear regression function}
\usage{
plotSEMM_contour(SEMLIdatapks, EtaN2 = "Eta2", EtaN1 = "Eta1",
  classinfo = TRUE, lnty = 3, lncol = 1, title = "", leg = TRUE,
  cex = 1.5, ...)
}
\arguments{
\item{SEMLIdatapks}{object returned from \code{\link{plotSEMM_setup}}}

\item{EtaN2}{Label for the X axis.  If no value is provided, defaults to "Eta2."}

\item{EtaN1}{Label for the Y axis.  If no value is provided, defaults to "Eta1."}

\item{classinfo}{Logical variable. TRUE shows the lines for each class as well as the combined estimate.
FALSE shows only the combined estimate.  If no value is provided, defaults to TRUE.}

\item{lnty}{Determines the line types used for the class lines.  If no value is provided, defaults to 3. 
See \code{\link{par}} for information about line type.}

\item{lncol}{Determines the line colors used for the class lines.  If no value is provided, defaults to 1. 
See \code{\link{par}} for information about line type.}

\item{title}{Titles the graph.}

\item{leg}{Logical variable.  If TRUE, a legend accompanies the graph.  If FALSE, no legend appears. 
Defaults to TRUE.}

\item{cex}{par(cex) value. Default is 1.5}

\item{...}{addition inputs, mostly from plotSEMM_GUI()}
}
\description{
Requires \code{plotSEMM_setup} be run first.  Generates (a) the potential nonlinear 
regression function; (b) bivariate distribution of the latent variables; 
(c) marginal distributions of the latent variables; (d) within class linear 
regression functions; and (e) within class marginal distributions for the latent variables.
}
\examples{
\dontrun{
## code for latent variables with two classes
pi <- c(0.602, 0.398)

alpha1 <- c(3.529, 2.317)

alpha2 <- c(0.02, 0.336)

beta21 <- c(0.152, 0.053)

psi11 <- c(0.265, 0.265)

psi22 <- c(0.023, 0.023)


plotobj <- plotSEMM_setup(pi, alpha1, alpha2, beta21, psi11, psi22)


plotSEMM_contour(plotobj)

plotSEMM_contour(plotobj, EtaN1 = "Latent Predictor", 
   EtaN2 = "Latent Outcome", classinfo = FALSE, lncol = 5) 
}
}
\references{
Pek, J. & Chalmers, R. P. (2015). Diagnosing Nonlinearity With Confidence Envelopes for a
Semiparametric Approach to Modeling Bivariate Nonlinear Relations Among Latent Variables.
\emph{Structural Equation Modeling, 22}, 288-293. \doi{10.1080/10705511.2014.937790}

Pek, J., Chalmers, R. P., Kok B. E., & Losardo, D. (2015). Visualizing Confidence Bands for
Semiparametrically Estimated Nonlinear Relations among Latent Variables.
\emph{Journal of Educational and Behavioral Statistics, 40}, 402-423. \doi{10.3102/1076998615589129}
}
\author{
Bethany Kok and Phil Chalmers \email{rphilip.chalmers@gmail.com}
}
\keyword{color}
\keyword{hplot}
