% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/one_compartment_oral.R
\name{one_compartment_oral}
\alias{one_compartment_oral}
\title{One-Compartment Oral Pharmacokinetic Model (Linear, First-Order Absorption)}
\arguments{
\item{data}{A data frame containing plasma concentration-time data.}

\item{time_col}{Character string specifying the column name for time.}

\item{conc_col}{Character string specifying the column name for plasma concentration.}

\item{dose}{Numeric value specifying the administered oral dose.}

\item{group_col}{Optional character string specifying a grouping variable
(e.g., formulation, subject).}

\item{plot}{Logical; if TRUE, generates a concentration-time plot with fitted lines.}

\item{annotate}{Logical; if TRUE, annotates the plot with PK parameters
(only if <= 2 groups).}
}
\value{
A list containing:
\describe{
  \item{\code{fitted_parameters}}{Data frame with C0, kel, t_half, Vd, CL, and R^2.}
  \item{\code{data}}{Processed data used for fitting and plotting.}
}
}
\description{
Fits plasma concentration-time data to the one-compartment oral pharmacokinetic model
using a linearized approach. The model assumes first-order absorption and first-order
elimination.

Model:
C(t) = (F * Dose * ka / (Vd * (ka - kel))) * (exp(-kel * t) - exp(-ka * t))

Linearized approximation:
Using log-transformed data in the elimination phase (t >> t_max), log(C) ~= log(C0) - kel * t

Parameters:
\itemize{
  \item ka: absorption rate constant
  \item kel: elimination rate constant
  \item C0: apparent initial concentration for elimination phase
  \item t_half: elimination half-life
  \item Vd: apparent volume of distribution
  \item CL: clearance
}
}
\examples{
# Example I: Single subject oral data
df <- data.frame(
  time = c(0.25, 0.5, 1, 2, 4, 6, 8, 12),
  concentration = c(5.1, 9.8, 14.2, 13.5, 10.2, 6.8, 4.5, 2.1)
)
one_compartment_oral(
  data = df,
  time_col = "time",
  conc_col = "concentration",
  dose = 100
)

# Example II: Condition-dependent kinetics
df_cond <- data.frame(
  time = rep(c(0.25, 0.5, 1, 2, 4, 6, 8), 2),
  concentration = c(
    4.8, 9.5, 13.7, 12.8, 9.2, 6.4, 3.9,   # Condition A
    5.2, 10.1, 14.0, 12.5, 8.7, 5.8, 3.5   # Condition B
  ),
  condition = rep(c("Condition A", "Condition B"), each = 7)
)
one_compartment_oral(
  data = df_cond,
  time_col = "time",
  conc_col = "concentration",
  dose = 100,
  group_col = "condition"
)

# Example III: Multiple subjects
df_subjects <- data.frame(
  time = rep(c(0.25, 0.5, 1, 2, 4, 6, 8), 10),
  concentration = c(
    5.0, 9.7, 14.0, 13.2, 10.0, 6.6, 4.2,  # Subject 1
    4.9, 9.5, 13.8, 12.9, 9.5, 6.3, 4.0,   # Subject 2
    5.1, 9.9, 14.1, 13.5, 10.3, 6.9, 4.3,  # Subject 3
    4.8, 9.6, 13.9, 13.1, 9.8, 6.5, 4.1,   # Subject 4
    5.2, 10.0, 14.3, 13.6, 10.5, 7.1, 4.4, # Subject 5
    5.1, 9.8, 14.0, 13.3, 10.1, 6.7, 4.3,  # Subject 6
    4.9, 9.6, 13.7, 12.8, 9.4, 6.2, 3.9,   # Subject 7
    5.0, 9.9, 14.2, 13.4, 10.2, 6.8, 4.1,  # Subject 8
    5.2, 10.1, 14.5, 13.7, 10.7, 7.2, 4.5, # Subject 9
    4.8, 9.5, 13.6, 12.7, 9.1, 6.0, 3.8    # Subject 10
  ),
  subject = rep(paste0("S", 1:10), each = 7)
)
one_compartment_oral(
  data = df_subjects,
  time_col = "time",
  conc_col = "concentration",
  dose = 100,
  group_col = "subject"
)
}
\references{
Gibaldi, M. & Perrier, D. (1982) <isbn:9780824710422> Pharmacokinetics,
2nd Edition. Marcel Dekker, New York.

Gabrielsson, J. & Weiner, D. (2000) <isbn:9186274929> Pharmacokinetic/Pharmacodynamic
Data Analysis: Concepts and Applications, 3rd Edition, Revised and Expanded.
Swedish Pharmaceutical Press, Stockholm.
}
\author{
Paul Angelo C. Manlapaz
}
