% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/first_order_release.R
\name{first_order_release}
\alias{first_order_release}
\title{First-Order Drug Release Kinetic Model}
\arguments{
\item{data}{A data frame containing experimental drug release data.}

\item{time_col}{Character string specifying the column name for time.}

\item{log_remain_col}{Column name for log cumulative percent drug remaining.}

\item{group_col}{Optional character string specifying a column for grouping
(e.g., formulation/batch).}

\item{pH_col}{Optional character string specifying a column containing pH values.}

\item{plot}{Logical; if TRUE, generates a plot of experimental data with
first-order fitted curves.}

\item{annotate}{Logical; if TRUE, annotates the plot with k1, intercept, R^2,
and t50 (only if <= 2 groups).}
}
\value{
A list containing:
\describe{
  \item{\code{fitted_parameters}}{Data frame with k1, intercept, R^2, and t50
        values for each group or pH condition.}
  \item{\code{data}}{The processed data used for model fitting and plotting.}
}
}
\description{
Fits experimental cumulative drug release data to a first-order kinetic model
using linear regression on the log-transformed unreleased fraction. The function
supports optional grouping (formulation/batch) and pH-dependent analysis. It
can generate plots with straight lines and annotations for first-order rate
constant (k1), intercept, coefficient of determination (R^2), and time required
for 50-percent drug release (t50).
}
\examples{
# Example I: Single formulation
df_1 <- data.frame(
  time = c(0, 15, 30, 45, 60, 90, 120, 150, 180),
  log_remain = c(2, 1.947, 1.899, 1.840, 1.780, 1.625, 1.447, 1.182, 0.813)
)
first_order_release(
  data = df_1,
  time_col = "time",
  log_remain_col = "log_remain"
)

# Example II: Two formulations (grouped, not pH-dependent)
df_2 <- data.frame(
  time = rep(c(0, 30, 60, 90, 120, 150), 2),
  log_remain = c(
    2.00, 1.84, 1.73, 1.53, 1.37, 1.25,  # Formulation A
    2.00, 1.88, 1.76, 1.67, 1.53, 1.39   # Formulation B
  ),
  formulation = rep(c("Formulation A", "Formulation B"), each = 6)
)
first_order_release(
  data = df_2,
  time_col = "time",
  log_remain_col = "log_remain",
  group_col = "formulation"
)

# Example III: pH-dependent first-order release
df_pH <- data.frame(
  time = rep(c(0, 60, 120, 180), 2),
  log_remain = c(
    2.00, 1.74, 1.38, 1.11,  # pH 7.4
    2.00, 1.84, 1.66, 1.48   # pH 4.5
  ),
  pH = rep(c(7.4, 4.5), each = 4)
)
first_order_release(
  data = df_pH,
  time_col = "time",
  log_remain_col = "log_remain",
  pH_col = "pH"
)

# Example IV: Two formulations under two pH conditions
df1 <- data.frame(
  time = rep(c(0, 30, 60, 90, 120, 150, 180), 2),
  log_remain = c(
    2.000, 1.918, 1.842, 1.755, 1.685, 1.598, 1.520,
    2.000, 1.865, 1.748, 1.612, 1.488, 1.352, 1.225
  ),
  pH = rep(c(4.5, 7.6), each = 7)
)
df2 <- data.frame(
  time = rep(c(0, 20, 40, 60, 80, 100, 120), 2),
  log_remain = c(
    2.000, 1.936, 1.872, 1.806, 1.742, 1.675, 1.610,
    2.000, 1.882, 1.760, 1.645, 1.522, 1.408, 1.295
  ),
  pH = rep(c(4.5, 7.6), each = 7)
)
df_all <- rbind(
  cbind(formulation = "Dataset 1", df1),
  cbind(formulation = "Dataset 2", df2)
)
first_order_release(
  data = df_all,
  time_col = "time",
  log_remain_col = "log_remain",
  group_col = "formulation",
  pH_col = "pH"
)
}
\references{
Ostwald, W. (1884) <doi:10.1002/prac.18840290139> Studien zur
chemischen Dynamik. Journal für Praktische Chemie, 29(1), 385–408.

Noyes, A. A., & Whitney, W. R. (1897) <doi:10.1021/ja02086a003> The
rate of solution of solid substances in their own solutions. Journal of the
American Chemical Society, 19(12), 930–934.
}
\author{
Paul Angelo C. Manlapaz
}
