% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partyfacts.R
\name{get_partyfacts_wikipedia}
\alias{get_partyfacts_wikipedia}
\title{Download Partyfacts Wikipedia data}
\usage{
get_partyfacts_wikipedia(cache = TRUE)
}
\arguments{
\item{cache}{Logical. If `TRUE` (default), caches the downloaded data for the
current R session to avoid repeated downloads.}
}
\value{
A tibble with columns: country, partyfacts_id, url, name_short, name,
  name_native, year_founded, year_dissolved.
}
\description{
Downloads the current Partyfacts Wikipedia dataset containing party names,
countries, and Wikipedia URLs for thousands of political parties worldwide.
}
\details{
The data comes from the Partyfacts project
(<https://partyfacts.herokuapp.com/>), which links party datasets and provides
Wikipedia URLs for political parties. The data is downloaded from the
Partyfacts GitHub repository.
}
\examples{
\donttest{
if (curl::has_internet()) {
  # Download the dataset
  pf_data <- get_partyfacts_wikipedia()

  # View parties from Germany
  pf_data[pf_data$country == "DEU", ]
}
}
}
\seealso{
[lookup_party_url()] for searching parties in the dataset.
}
