% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partyfacts.R
\name{get_party_info_by_name}
\alias{get_party_info_by_name}
\title{Get party info by name}
\usage{
get_party_info_by_name(
  party_name,
  country = NULL,
  all_colors = FALSE,
  data = NULL
)
}
\arguments{
\item{party_name}{A character string with the party name to search for.}

\item{country}{Optional. ISO 3-letter country code to filter results.}

\item{all_colors}{Logical. If `TRUE`, includes all colors as a list-column.
Default is `FALSE`.}

\item{data}{Optional. A Partyfacts dataset.}
}
\value{
A tibble with party info, color, and logo_url columns. Returns a
  tibble with zero rows if no party is found.
}
\description{
A convenience function that combines party lookup with color and logo
extraction. Searches for a party by name, finds its Wikipedia URL, and
extracts both color and logo.
}
\examples{
\donttest{
if (curl::has_internet()) {
  # Get info for German SPD
  get_party_info_by_name("SPD", country = "DEU")

  # Search more broadly with all colors
  get_party_info_by_name("Labour", country = "GBR", all_colors = TRUE)
}
}
}
