% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/party_info.R
\name{get_party_info}
\alias{get_party_info}
\title{Extract party information from Wikipedia}
\usage{
get_party_info(url, all_colors = FALSE)
}
\arguments{
\item{url}{A character vector of Wikipedia URLs for political party pages.}

\item{all_colors}{Logical. If `FALSE` (default), returns only the primary
color in the `color` column. If `TRUE`, adds an `all_colors` list-column.}
}
\value{
A tibble with columns: `url`, `color` (primary color as hex),
  `logo_url`, and optionally `all_colors` (list of all colors).
}
\description{
Extracts both the party color(s) and logo URL from a political party's
English Wikipedia page in a single call.
}
\details{
This function combines [get_party_color()] and [get_party_logo()] into
a single call, which is more efficient when you need both pieces of
information as it only fetches each Wikipedia page once.
}
\examples{
\donttest{
if (curl::has_internet()) {
  # Get info for multiple parties
  urls <- c(
    "https://en.wikipedia.org/wiki/Democratic_Party_(United_States)",
    "https://en.wikipedia.org/wiki/Republican_Party_(United_States)",
    "https://en.wikipedia.org/wiki/Social_Democratic_Party_of_Germany"
  )
  get_party_info(urls)

  # Include all colors
  get_party_info(urls, all_colors = TRUE)
}
}
}
