% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osrmNearest.R
\name{osrmNearest}
\alias{osrmNearest}
\title{Get the Nearest Point on the Street Network}
\usage{
osrmNearest(
  loc,
  n = 1,
  exclude,
  osrm.server = getOption("osrm.server"),
  osrm.profile = getOption("osrm.profile")
)
}
\arguments{
\item{loc}{a point to snap to the street network. \code{loc} can be: \itemize{
  \item a vector of coordinates (longitude and latitude, WGS 84),
  \item a data.frame of longitudes and latitudes (WGS 84),
  \item a matrix of longitudes and latitudes (WGS 84),
  \item an sfc object of type POINT,
  \item an sf object of type POINT.
}
If \code{loc} is a data.frame, a matrix, an sfc object or an sf object then
only the first row or element is considered.}

\item{n}{number of nearest points}

\item{exclude}{pass an optional "exclude" request option to the OSRM API.}

\item{osrm.server}{the base URL of the routing server.}

\item{osrm.profile}{the routing profile to use, e.g. "car", "bike" or "foot".}
}
\value{
The output of this function is an sf POINT of the point on the street
network.\cr
It contains 2 fields: \itemize{
  \item id, the point identifier
  \item distance, the distance in meters to the supplied input point.
  }
}
\description{
This function interfaces with the \emph{nearest} OSRM
service.\cr
}
\examples{
\dontrun{
library(sf)
apotheke.sf <- st_read(system.file("gpkg/apotheke.gpkg", package = "osrm"),
  quiet = TRUE
)
pt <- osrmNearest(apotheke.sf[56, ])
pt$distance
}
}
