% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api-record.R
\name{orcid_fetch_many}
\alias{orcid_fetch_many}
\title{Retrieve records for multiple ORCID identifiers}
\usage{
orcid_fetch_many(
  orcid_ids,
  section = "works",
  token = NULL,
  stop_on_error = FALSE
)
}
\arguments{
\item{orcid_ids}{Character vector. Valid ORCID identifiers in the format
XXXX-XXXX-XXXX-XXXX. Can also handle URLs like https://orcid.org/XXXX-XXXX-XXXX-XXXX.}

\item{section}{Character string. Section to fetch. One of: "employments",
"educations", "distinctions", "invited-positions", "memberships",
"qualifications", "services", "research-resources", "works", "funding",
or "peer-reviews".}

\item{token}{Character string or NULL. Optional API token for authenticated
requests. If NULL (default), checks the ORCID_TOKEN environment variable.}

\item{stop_on_error}{Logical. If TRUE, stops on the first error. If FALSE
(default), continues processing and returns results for successful requests,
issuing warnings for failures.}
}
\value{
A data.table combining results from all successful requests. The
orcid column identifies which ORCID each row belongs to.
}
\description{
Fetches data for multiple ORCID identifiers. This is a convenience function
that loops over a vector of ORCID iDs and fetches the specified section(s)
for each. Results are combined into a single data.table.
}
\details{
This function makes one API request per ORCID identifier. Be mindful of
rate limits when fetching data for many ORCIDs.

The function validates each ORCID identifier and normalizes formats before
making requests.

For rate limit compliance, consider adding delays between large batches
or using authenticated requests which typically have higher rate limits.
}
\examples{
\dontrun{
# Fetch works for multiple ORCIDs
orcids <- c("0000-0002-1825-0097", "0000-0003-1419-2405")
works <- orcid_fetch_many(orcids, section = "works")
print(works)

# Fetch employments for multiple ORCIDs
employments <- orcid_fetch_many(orcids, section = "employments")

# Stop on first error
works <- orcid_fetch_many(orcids, section = "works", stop_on_error = TRUE)
}

}
\references{
ORCID API Documentation: \url{https://info.orcid.org/documentation/api-tutorials/}
}
\seealso{
\code{\link{orcid_fetch_record}}, \code{\link{orcid_works}}, \code{\link{orcid_employments}}
}
