% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_qtrap.R
\name{generate_process_report}
\alias{generate_process_report}
\title{Generate Process Report for Sciex 7500/5500 Raw Data}
\usage{
generate_process_report(
  input_file,
  output_file = NULL,
  filter_blank = TRUE,
  blank_string = "Blank|BLANK|blank",
  filter_nist = TRUE,
  nist_string = "NIST|Nist|nist",
  imputation_threshold = 0.25,
  imputation_method = "half_min",
  qc_string = "QC",
  include_is_normalization = TRUE,
  include_qc_rlsc = TRUE,
  include_pqn = TRUE,
  include_qc_rsd = TRUE,
  include_snr_flag = TRUE,
  snr_threshold = 10,
  include_area_flag = TRUE,
  include_height_flag = TRUE,
  id_col = "sample_id",
  ignore_na = TRUE
)
}
\arguments{
\item{input_file}{The path to the input file containing raw data.}

\item{output_file}{The path to the output zip file.}

\item{filter_blank}{Logical, whether to filter out blank samples (default: TRUE).}

\item{blank_string}{Character, regular expression pattern to match blank sample IDs (default: 'Blank|BLANK|blank').}

\item{filter_nist}{Logical, whether to filter out NIST samples (default: TRUE).}

\item{nist_string}{Character, regular expression pattern to match NIST sample IDs (default: 'NIST|Nist|nist').}

\item{imputation_threshold}{Numeric, threshold for missing value imputation (default: 0.25).}

\item{imputation_method}{Character, method for missing value imputation (default: 'half_min').}

\item{qc_string}{Character, regular expression pattern to match QC sample IDs (default: 'QC').}

\item{include_is_normalization}{Logical, whether to include internal standard normalization (default: TRUE).}

\item{include_qc_rlsc}{Logical, whether to include QC-RLSC normalization (default: TRUE).}

\item{include_pqn}{Logical, whether to include PQN normalization (default: TRUE).}

\item{include_qc_rsd}{Logical, whether to include QC RSD calculation (default: TRUE).}

\item{include_snr_flag}{Logical, whether to include Signal-to-Noise ratio flagging (default: TRUE).}

\item{snr_threshold}{Numeric, threshold for Signal-to-Noise ratio flagging (default: 10).}

\item{include_area_flag}{Logical, whether to include area threshold flagging (default: TRUE).}

\item{include_height_flag}{Logical, whether to include height threshold flagging (default: TRUE).}

\item{id_col}{Character, name of the column containing sample IDs (default: 'sample_id').}

\item{ignore_na}{Logical, whether to ignore NA values in QC RSD calculation (default: TRUE).}
}
\value{
The path to the generated zip file containing the process report.
}
\description{
This function generates a comprehensive process report for Sciex 7500/5500 raw data,
including data normalization, missing value imputation, and optional normalization
and flagging steps. The results are saved in a temporary directory and then zipped
into a file for easy sharing.
}
\author{
Yaoxiang Li
}
