% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/netgraph.netconnection.R
\name{netgraph.netconnection}
\alias{netgraph.netconnection}
\title{Network graph for objects of class netconnection}
\usage{
\method{netgraph}{netconnection}(
  x,
  seq,
  col = seq_len(x$n.subnets),
  reference.group = NULL,
  plastic = gs("plastic"),
  start.layout = "circle",
  iterate = FALSE,
  ...
)
}
\arguments{
\item{x}{An object of class \code{netconnection}.}

\item{seq}{A character or numerical vector specifying the sequence
of treatments arrangement (anticlockwise if \code{start.layout =
"circle"}).}

\item{col}{A single color (or vector of colors) for lines
connecting treatments (edges) if argument \code{plastic = FALSE}
(see Details).}

\item{reference.group}{Reference treatment (only relevant for
disconnected networks).}

\item{plastic}{A logical indicating whether the appearance of the
comparisons should be in '3D look'.}

\item{start.layout}{A character string indicating which starting
layout is used (see \code{\link{netgraph.netmeta}}).}

\item{iterate}{A logical indicating whether the stress majorization
algorithm is carried out for optimization of the layout
(see \code{\link{netgraph.netmeta}}).}

\item{\dots}{Additional arguments passed on to
\code{\link{netgraph.netmeta}} (see Details).}
}
\description{
This function generates a graph of the evidence network.
}
\details{
Argument \code{col} can be a single color for all edges, a vector
of length equal to the number of edges, or a vector of length equal
to the number of subnetworks. Argument \code{reference.group} is
only considered in disconnected networks, i.e., if more than one
(sub)network exists, and if argument \code{col} provides colors for
subnetworks. In this case, the first color provided in argument
\code{col} defines the color for the subnetwork with the reference
treatment.
}
\examples{
# Artificial example with two subnetworks
#
t1 <- c("G", "B", "B", "D", "A", "F")
t2 <- c("B", "C", "E", "E", "H", "A")
#
nc1 <- netconnection(t1, t2)
print(nc1, details = TRUE)

netgraph(nc1, points = TRUE, adj = 0.5, bg.points = "lightgray")
netgraph(nc1, points = TRUE, adj = 0.5, bg.points = "lightgray",
  plastic = TRUE)

}
\seealso{
\code{\link{netconnection}}, \code{\link{netgraph.netmeta}}
}
\author{
Guido Schwarzer \email{guido.schwarzer@uniklinik-freiburg.de},
  Gerta Rücker \email{gerta.ruecker@uniklinik-freiburg.de}
}
\keyword{hplot}
