% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/track-attributes.R
\name{emr_track.attr.export}
\alias{emr_track.attr.export}
\title{Returns attributes values of tracks}
\usage{
emr_track.attr.export(track = NULL, attr = NULL, include_missing = FALSE)
}
\arguments{
\item{track}{a vector of track names or 'NULL'}

\item{attr}{a vector of attribute names or 'NULL'}

\item{include_missing}{when TRUE - adds a row for tracks which do not have the 'attr' with NA,
or tracks which do not exist. Otherwise tracks without an attribute would be omitted from the data
frame, and an error would be thrown for tracks which do not exist.}
}
\value{
A data frame containing attributes values of tracks.
}
\description{
Returns attributes values of tracks.
}
\details{
This function returns a data frame that contains attributes values of one or
more tracks. The data frame is constituted of 3 columns named 'track',
'attr' and 'value'.

'track' parameter is optionally used to retrieve only the attributes of the
specific track(s). If 'NULL', attributes of all the tracks are returned.

Likewise 'attr' allows to retrieve only specifically named attributes.

If both 'track' and 'attr' are used, the attributes that fulfill both of the
conditions are returned

Overriding a track also overrides it's track attributes, the
attributes will persist when the track is no longer overridden.
}
\examples{

emr_db.init_examples()
emr_track.attr.export()
emr_track.attr.set("sparse_track", "gender", "female")
emr_track.attr.set("sparse_track", "tag", "")
emr_track.attr.set("dense_track", "gender", "male")
emr_track.attr.export()
emr_track.attr.export(track = "sparse_track")
emr_track.attr.export(attr = "gender")
emr_track.attr.export(track = "sparse_track", attr = "gender")
}
\seealso{
\code{\link{emr_track.attr.get}}, \code{\link{emr_track.attr.set}}
}
\keyword{~attr}
\keyword{~attribute}
