% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/states.R
\name{mc_states_join}
\alias{mc_states_join}
\title{Create states for join conflicts}
\usage{
mc_states_join(
  data,
  tag = "join_conflict",
  by_type = TRUE,
  tolerance = NULL,
  older_newer_suffix = FALSE
)
}
\arguments{
\item{data}{myClim object in Raw-format. see \link{myClim-package}}

\item{tag}{The tag name (default "join_conflict").}

\item{by_type}{for \link{mc_join} function (default TRUE)}

\item{tolerance}{for \link{mc_join} function (default NULL)}

\item{older_newer_suffix}{if true, the suffix \verb{_older}/\verb{_newer} is added to the tag name (default FALSE)}
}
\value{
Returns a myClim object with added states.
}
\description{
This function creates a state (tag) when joining multiple overlapping
time-series with different microclimate values.  State is created for
all values that are in conflict in joining process.
}
\details{
For more info see details of \link{mc_join} function.
Parameter \code{older_newer_suffix} can be used for easier filtering of tags,
to distinguish whether certain state on overlapping time series is connected
to older or newer record. It can help to decide which value keep and which remove.
The loggers with same start and end datetimes cannot be marked as older/newer.
Tag is without suffix in this case.
}
