% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_1_MAP.R
\name{estimate_1_MAP}
\alias{estimate_1_MAP}
\title{Estimation Method: Maximum A Posteriori (MAP)}
\usage{
estimate_1_MAP(
  data,
  colnames,
  behrule,
  ids = NULL,
  models,
  funcs = NULL,
  priors,
  settings = NULL,
  algorithm,
  lowers,
  uppers,
  control,
  ...
)
}
\arguments{
\item{data}{A data frame in which each row represents a single trial,
see \link[multiRL]{data}}

\item{colnames}{Column names in the data frame,
see \link[multiRL]{colnames}}

\item{behrule}{The agent’s implicitly formed internal rule,
see \link[multiRL]{behrule}}

\item{ids}{The Subject ID of the participant whose data needs to be fitted.}

\item{models}{Reinforcement Learning Models}

\item{funcs}{The functions forming the reinforcement learning model,
see \link[multiRL]{funcs}}

\item{priors}{Prior probability density function of the free parameters,
see \link[multiRL]{priors}}

\item{settings}{Other model settings, 
see \link[multiRL]{settings}}

\item{algorithm}{Algorithm packages that multiRL supports, 
see \link[multiRL]{algorithm}}

\item{lowers}{Lower bound of free parameters in each model.}

\item{uppers}{Upper bound of free parameters in each model.}

\item{control}{Settings manage various aspects of the iterative process,
see \link[multiRL]{control}}

\item{...}{Additional arguments passed to internal functions.}
}
\value{
An S3 object of class \code{DataFrame} containing, for each model, 
 the estimated optimal parameters and associated model fit metrics.
}
\description{
This function first performs a maximum likelihood estimation (MLE) to 
   obtain the best-fitting parameters for all subjects based on maximum 
   likelihood. It then computes the likelihood-based posterior using 
   user-specified prior distributions. Based on the current group-level 
   data, the prior distributions are subsequently updated. This procedure 
   is iteratively repeated until the likelihood-based posterior converges. 
   The entire process is referred to as Expectation–Maximization with 
   Maximum A Posteriori estimation(EM-MAP).
}
