% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/components.R, R/documentation.R, R/inputs.R
\name{Slider}
\alias{Slider}
\alias{Slider.shinyInput}
\alias{updateSlider.shinyInput}
\title{Slider}
\usage{
Slider(...)

Slider.shinyInput(inputId, ..., value = defaultValue)

updateSlider.shinyInput(
  session = shiny::getDefaultReactiveDomain(),
  inputId,
  ...
)
}
\arguments{
\item{...}{Props to pass to the component.}

\item{inputId}{ID of the component.}

\item{value}{Starting value.}

\item{session}{Object passed as the `session` argument to Shiny server.}
}
\value{
Object with \code{shiny.tag} class suitable for use in the UI of a Shiny app.
}
\description{
\url{https://mui.com/material-ui/api/slider/}
}
\details{
\itemize{
\item aria-label \code{string} \cr Default is - The label of the slider.
\item aria-labelledby \code{string} \cr Default is - The id of the element containing a label for the slider.
\item aria-valuetext \code{string} \cr Default is - A string value that provides a user-friendly name for the current value of the slider.
\item classes \code{object} \cr Default is - Override or extend the styles applied to the component.See CSS classes API below for more details.
\item color \code{'primary'| 'secondary'| 'error'| 'info'| 'success'| 'warning'| string} \cr Default is 'primary' The color of the component. It supports both default and custom theme colors, which can be added as shown in the palette customization guide.
\item components \verb{\{ Input?: elementType, Mark?: elementType, MarkLabel?: elementType, Rail?: elementType, Root?: elementType, Thumb?: elementType, Track?: elementType, ValueLabel?: elementType \}} \cr Default is The components used for each slot inside.Deprecated use the slots prop instead. This prop will be removed in a future major release. See Migrating from deprecated APIs for more details.
\item componentsProps \verb{\{ input?: func| object, mark?: func| object, markLabel?: func| object, rail?: func| object, root?: func| object, thumb?: func| object, track?: func| object, valueLabel?: func| \{ children?: element, className?: string, open?: bool, style?: object, value?: node, valueLabelDisplay?: 'auto'| 'off'| 'on' \} \}} \cr Default is The extra props for the slot components. You can override the existing props or add new ones.Deprecated use the slotProps prop instead. This prop will be removed in a future major release. See Migrating from deprecated APIs for more details.
\item defaultValue \code{Array} \cr Default is - The default value. Use when the component is not controlled.
\item disabled \code{bool} \cr Default is FALSE If true, the component is disabled.
\item disableSwap \code{bool} \cr Default is FALSE If true, the active thumb doesn't swap when moving pointer over a thumb while dragging another thumb.
\item getAriaLabel \code{func} \cr Default is - Accepts a function which returns a string value that provides a user-friendly name for the thumb labels of the slider. This is important for screen reader users.Signature:function(index: number) = stringindex The thumb label's index to format.
\item getAriaValueText \code{func} \cr Default is - Accepts a function which returns a string value that provides a user-friendly name for the current value of the slider. This is important for screen reader users.Signature:function(value: number, index: number) = stringvalue The thumb label's value to format.index The thumb label's index to format.
\item marks \verb{Array \{ label?: node, value: number \} | bool} \cr Default is FALSE Marks indicate predetermined values to which the user can move the slider. If true the marks are spaced according the value of the step prop. If an array, it should contain objects with value and an optional label keys.
\item max \code{number} \cr Default is 100 The maximum allowed value of the slider. Should not be equal to min.
\item min \code{number} \cr Default is 0 The minimum allowed value of the slider. Should not be equal to max.
\item name \code{string} \cr Default is - Name attribute of the hidden input element.
\item onChange \code{func} \cr Default is - Callback function that is fired when the slider's value changed.Signature:function(event: Event, value: Value, activeThumb: number) = voidevent The event source of the callback. You can pull out the new value by accessing event.target.value (any). Warning: This is a generic event not a change event.value The new value.activeThumb Index of the currently moved thumb.
\item onChangeCommitted \code{func} \cr Default is - Callback function that is fired when the mouseup is triggered.Signature:function(event: React.SyntheticEvent | Event, value: Value) = voidevent The event source of the callback. Warning: This is a generic event not a change event.value The new value.
\item orientation \code{'horizontal'| 'vertical'} \cr Default is 'horizontal' The component orientation.
\item scale \code{func} \cr Default is function Identity(x) return x; A transformation function, to change the scale of the slider.Signature:function(x: any) = any
\item shiftStep \code{number} \cr Default is 10 The granularity with which the slider can step through values when using Page Up/Page Down or Shift + Arrow Up/Arrow Down.
\item size \code{'small'| 'medium'| string} \cr Default is 'medium' The size of the slider.
\item slotProps \verb{\{ input?: func| object, mark?: func| object, markLabel?: func| object, rail?: func| object, root?: func| object, thumb?: func| object, track?: func| object, valueLabel?: func| \{ children?: element, className?: string, open?: bool, style?: object, value?: node, valueLabelDisplay?: 'auto'| 'off'| 'on' \} \}} \cr Default is The props used for each slot inside the Slider.
\item slots \verb{\{ input?: elementType, mark?: elementType, markLabel?: elementType, rail?: elementType, root?: elementType, thumb?: elementType, track?: elementType, valueLabel?: elementType \}} \cr Default is The components used for each slot inside the Slider. Either a string to use a HTML element or a component.
\item step \code{number} \cr Default is 1 The granularity with which the slider can step through values. (A "discrete" slider.) The min prop serves as the origin for the valid values. We recommend (max - min) to be evenly divisible by the step.When step is null, the thumb can only be slid onto marks provided with the marks prop.
\item sx \code{Array} \cr Default is - The system prop that allows defining system overrides as well as additional CSS styles.See the \code{sx} page for more details.
\item tabIndex \code{number} \cr Default is - Tab index attribute of the hidden input element.
\item track \code{'inverted'| 'normal'| false} \cr Default is 'normal' The track presentation: normal the track will render a bar representing the slider value. inverted the track will render a bar representing the remaining slider value. false the track will render without a bar.
\item value \code{Array} \cr Default is - The value of the slider. For ranged sliders, provide an array with two values.
\item valueLabelDisplay \code{'auto'| 'off'| 'on'} \cr Default is 'off' Controls when the value label is displayed: auto the value label will display when the thumb is hovered or focused. on will display persistently. off will never display.
\item valueLabelFormat \code{func| string} \cr Default is function Identity(x) return x; The format function the value label's value.When a function is provided, it should have the following signature:- number value The value label's value to format - number index The value label's index to format
}
}
