% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.MFx.R
\name{plot.MFx}
\alias{plot.MFx}
\title{Plotting method for \code{MFx} objects}
\usage{
\method{plot}{MFx}(
  x,
  x_variable = "MFx",
  xlab = NULL,
  ylab = "Survival probability \\n median and 95 CI",
  main = NULL,
  log_scale = FALSE,
  ncol = 3,
  ...
)
}
\arguments{
\item{x}{An object of class \code{MFx}.}

\item{x_variable}{A character to define the variable for the \eqn{X}-axis,
either \code{"MFx"} or \code{"Time"}. The default is \code{"MFx"}.}

\item{xlab}{A label for the \eqn{X}-axis, by default \code{NULL} and depend on the
argument \code{x_variable}.}

\item{ylab}{A label for the \eqn{Y}-axis, by default \code{Survival probability median and 95 CI}.}

\item{main}{A main title for the plot.}

\item{log_scale}{If \code{TRUE}, the x-axis is log-scaled. Default is \code{FALSE}.}

\item{ncol}{An interger for the number of columns when several panels are plotted.}

\item{\dots}{Further arguments to be passed to generic methods.}
}
\value{
a plot of class \code{ggplot}
}
\description{
This is the generic \code{plot} S3 method for the
\code{MFx} class. It plots the survival probability as a function of
the multiplication factor applied or as a function of time.
}
\keyword{plot}
