\name{gmmfit-class}
\docType{class}
\alias{gmmfit-class}

\title{Class \code{"gmmfit"}}
\description{
A class to store a fitted model obtained using GMM.
}
\section{Objects from the Class}{
Objects can be created by calls of the form \code{new("gmmfit", ...)}.
Generated by \code{\link{gmmFit}}.
}
\section{Slots}{
  \describe{
    \item{\code{theta}:}{Object of class \code{"numeric"} ~~ }
    \item{\code{convergence}:}{Object of class \code{"list"} ~~ }
    \item{\code{convIter}:}{Object of class \code{"numericORNULL"} ~~ }
    \item{\code{call}:}{Object of class \code{"callORNULL"} ~~ }
    \item{\code{type}:}{Object of class \code{"character"} ~~ }
    \item{\code{wObj}:}{Object of class \code{"momentWeights"} ~~ }
    \item{\code{niter}:}{Object of class \code{"integer"} ~~ }
    \item{\code{efficientGmm}:}{Object of class \code{"logical"} ~~ }
    \item{\code{model}:}{Object of class \code{"momentModel"} ~~ }
  }
}
\section{Methods}{
  \describe{
    \item{bread}{\code{signature(x = "gmmfit")}: ... }
    \item{coef}{\code{signature(object = "gmmfit")}: ... }
    \item{confint}{\code{signature(object = "gmmfit")}: ... }
    \item{DWH}{\code{signature(object1 = "gmmfit", object2 = "gmmfit")}: ... }
    \item{DWH}{\code{signature(object1 = "gmmfit", object2 = "lm")}: ... }
    \item{DWH}{\code{signature(object1 = "gmmfit", object2 = "missing")}: ... }
    \item{hypothesisTest}{\code{signature(object.u = "gmmfit", object.r = "gmmfit")}: ... }
    \item{hypothesisTest}{\code{signature(object.u = "gmmfit", object.r = "missing")}: ... }
    \item{hypothesisTest}{\code{signature(object.u = "missing", object.r = "gmmfit")}: ... }
    \item{meatGmm}{\code{signature(object = "gmmfit")}: ... }
    \item{print}{\code{signature(x = "gmmfit")}: ... }
    \item{residuals}{\code{signature(object = "gmmfit")}: ... }
    \item{show}{\code{signature(object = "gmmfit")}: ... }
    \item{specTest}{\code{signature(object = "gmmfit", which = "missing")}: ... }
    \item{specTest}{\code{signature(object = "gmmfit", which = "numeric")}: ... }
    \item{summary}{\code{signature(object = "gmmfit")}: ... }
    \item{update}{\code{signature(object = "gmmfit")}: ... }
    \item{vcov}{\code{signature(object = "gmmfit")}: ... }
	 }
}

\examples{
showClass("gmmfit")
}
\keyword{classes}
