% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sequence.R
\name{gseq.kmer.dist}
\alias{gseq.kmer.dist}
\title{Compute k-mer distribution in genomic intervals}
\usage{
gseq.kmer.dist(intervals, k = 6L, mask = NULL)
}
\arguments{
\item{intervals}{Genomic intervals to analyze}

\item{k}{Integer k-mer size (1-10). Default is 6.}

\item{mask}{Optional intervals to exclude from counting. Positions within
the mask will not contribute to k-mer counts.}
}
\value{
A data frame with columns:
  \describe{
    \item{kmer}{Character string representing the k-mer sequence}
    \item{count}{Number of occurrences of this k-mer}
  }
  Only k-mers with count > 0 are included. K-mers containing N bases
  are not counted.
}
\description{
Counts the occurrence of all k-mers (of size k) within the specified
genomic intervals, optionally excluding masked regions.
}
\examples{
gdb.init_examples()

# Count all 6-mers in first 10kb of chr1
intervals <- data.frame(chrom = "chr1", start = 0, end = 10000)
kmer_dist <- gseq.kmer.dist(intervals, k = 6)
head(kmer_dist)

# Count dinucleotides
dinucs <- gseq.kmer.dist(intervals, k = 2)
dinucs

# Count with mask
mask <- data.frame(chrom = "chr1", start = 5000, end = 6000)
kmer_dist_masked <- gseq.kmer.dist(intervals, k = 6, mask = mask)

}
\seealso{
\code{\link{gseq.extract}}, \code{\link{gseq.kmer}}
}
