% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trans_func.R
\name{trans_func}
\alias{trans_func}
\title{Create \code{trans_func} object for functional prediction.}
\description{
This class is a wrapper for a series of functional prediction analysis on ASVs/OTUs/species and communities, including the prokaryotic function/trait prediction based on 
Louca et al. (2016) <doi:10.1126/science.aaf4507> and Lim et al. (2020) <10.1038/s41597-020-0516-5>, 
or fungal function/trait prediction based on Nguyen et al. (2016) <10.1016/j.funeco.2015.06.006> and Polme et al. (2020) <doi:10.1007/s13225-020-00466-2>; 
functional redundancy calculation and metabolic pathway abundance prediction Abhauer et al. (2015) <10.1093/bioinformatics/btv287>.
}
\examples{

## ------------------------------------------------
## Method `trans_func$new`
## ------------------------------------------------

data(dataset)
t1 <- trans_func$new(dataset = dataset)

## ------------------------------------------------
## Method `trans_func$cal_func`
## ------------------------------------------------

\donttest{
t1$cal_func(prok_database = "FAPROTAX")
}

## ------------------------------------------------
## Method `trans_func$cal_func_FR`
## ------------------------------------------------

\donttest{
t1$cal_func_FR(abundance_weighted = TRUE)
}

## ------------------------------------------------
## Method `trans_func$trans_func_FR`
## ------------------------------------------------

\donttest{
t1$trans_func_FR()
}

## ------------------------------------------------
## Method `trans_func$plot_func_FR`
## ------------------------------------------------

\donttest{
t1$plot_func_FR()
}

## ------------------------------------------------
## Method `trans_func$cal_func_FR_comm`
## ------------------------------------------------

\donttest{
t1$cal_func_FR_comm()
}

## ------------------------------------------------
## Method `trans_func$show_prok_func`
## ------------------------------------------------

\donttest{
t1$show_prok_func(use_func = "methanotrophy")
}

## ------------------------------------------------
## Method `trans_func$cal_tax4fun2`
## ------------------------------------------------

\dontrun{
t1$cal_tax4fun2(blast_tool_path = "ncbi-blast-2.5.0+/bin", 
    path_to_reference_data = "Tax4Fun2_ReferenceData_v2")
}

## ------------------------------------------------
## Method `trans_func$cal_tax4fun2_FRI`
## ------------------------------------------------

\dontrun{
t1$cal_tax4fun2_FRI()
}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{func_group_list}}{store and show the function group list}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-trans_func-new}{\code{trans_func$new()}}
\item \href{#method-trans_func-cal_func}{\code{trans_func$cal_func()}}
\item \href{#method-trans_func-cal_func_FR}{\code{trans_func$cal_func_FR()}}
\item \href{#method-trans_func-trans_func_FR}{\code{trans_func$trans_func_FR()}}
\item \href{#method-trans_func-plot_func_FR}{\code{trans_func$plot_func_FR()}}
\item \href{#method-trans_func-cal_func_FR_comm}{\code{trans_func$cal_func_FR_comm()}}
\item \href{#method-trans_func-show_prok_func}{\code{trans_func$show_prok_func()}}
\item \href{#method-trans_func-cal_tax4fun2}{\code{trans_func$cal_tax4fun2()}}
\item \href{#method-trans_func-cal_tax4fun2_FRI}{\code{trans_func$cal_tax4fun2_FRI()}}
\item \href{#method-trans_func-cal_spe_func}{\code{trans_func$cal_spe_func()}}
\item \href{#method-trans_func-cal_spe_func_perc}{\code{trans_func$cal_spe_func_perc()}}
\item \href{#method-trans_func-trans_spe_func_perc}{\code{trans_func$trans_spe_func_perc()}}
\item \href{#method-trans_func-plot_spe_func_perc}{\code{trans_func$plot_spe_func_perc()}}
\item \href{#method-trans_func-clone}{\code{trans_func$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trans_func-new"></a>}}
\if{latex}{\out{\hypertarget{method-trans_func-new}{}}}
\subsection{Method \code{new()}}{
Create the \code{trans_func} object. This function can identify the data type for Prokaryotes or Fungi automatically.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_func$new(dataset = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dataset}}{the object of \code{\link{microtable}} Class.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{for_what}: "prok" or "fungi" or NA, "prok" represent prokaryotes. "fungi" represent fungi. NA stand for unknown according to the Kingdom information. 
In this case, if the user still want to use the function to identify species traits, please provide "prok" or "fungi" manually, 
e.g. \code{t1$for_what <- "prok"}.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{data(dataset)
t1 <- trans_func$new(dataset = dataset)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trans_func-cal_func"></a>}}
\if{latex}{\out{\hypertarget{method-trans_func-cal_func}{}}}
\subsection{Method \code{cal_func()}}{
Predict the functions or traits for each ASV/OTU/species by matching taxonomic assignments to functional database.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_func$cal_func(
  prok_database = c("FAPROTAX", "NJC19")[1],
  fungi_database = c("FUNGuild", "FungalTraits")[1],
  FUNGuild_confidence = c("Highly Probable", "Probable", "Possible")
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{prok_database}}{default "FAPROTAX"; \code{"FAPROTAX"} or \code{"NJC19"}; select a prokaryotic database:
\describe{
  \item{\strong{'FAPROTAX'}}{FAPROTAX; Reference: Louca et al. (2016). Decoupling function and taxonomy in the global ocean microbiome. 
        Science, 353(6305), 1272. <doi:10.1126/science.aaf4507>}
  \item{\strong{'NJC19'}}{NJC19: Lim et al. (2020). Large-scale metabolic interaction network of the mouse and human gut microbiota. 
        Scientific Data, 7(1). <10.1038/s41597-020-0516-5>. 
        Note that the matching in this database is performed at the species level, 
        hence utilizing it demands a higher level of precision in regards to the assignments of species in the taxonomic information table.}
}}

\item{\code{fungi_database}}{default "FUNGuild"; \code{"FUNGuild"} or \code{"FungalTraits"}; select a fungal database:
\describe{
  \item{\strong{'FUNGuild'}}{Nguyen et al. (2016) FUNGuild: An open annotation tool for parsing fungal community datasets by ecological guild.
        Fungal Ecology, 20(1), 241-248, <doi:10.1016/j.funeco.2015.06.006>}
  \item{\strong{'FungalTraits'}}{version: FungalTraits_1.2_ver_16Dec_2020V.1.2; Polme et al. 
        FungalTraits: a user-friendly traits database of fungi and fungus-like stramenopiles.  
        Fungal Diversity 105, 1-16 (2020). <doi:10.1007/s13225-020-00466-2>}
}}

\item{\code{FUNGuild_confidence}}{default c("Highly Probable", "Probable", "Possible"). 
Selected 'confidenceRanking' when \code{fungi_database = "FUNGuild"}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{res_func} stored in the object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
t1$cal_func(prok_database = "FAPROTAX")
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trans_func-cal_func_FR"></a>}}
\if{latex}{\out{\hypertarget{method-trans_func-cal_func_FR}{}}}
\subsection{Method \code{cal_func_FR()}}{
Calculating the functional redundancy (FR) of communities for each function/trait.
For each sample and each function/trait, there will be a FR value in the result table.
The FR is defined:
     \deqn{FR_{kj}^{unweighted} = \frac{N_{j}}{N_{k}} \cdot {AF}}
     \deqn{FR_{kj}^{weighted} = \frac{\sum_{i=1}^{N_{j}} A_{i}}{\sum_{i=1}^{N_{k}} A_{i}} \cdot {AF}}
where \eqn{FR_{kj}} denotes the FR for sample k and function j. \eqn{N_{k}} is the species number in sample k.
\eqn{N_{j}} is the number of species with function j in sample k.
\eqn{A_{i}} is the abundance (counts) of species i in sample k.
\eqn{AF} is adjustment factor based on taxonomic information, representing the taxonomic dispersion of ASVs/OTUs/Species. It is 1 when \code{adj_tax = FALSE}.
Please see the parameter \code{adj_tax} for detailed explanation.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_func$cal_func_FR(
  abundance_weighted = FALSE,
  adj_tax = FALSE,
  adj_tax_by = "Genus",
  perc = FALSE,
  dec = 6,
  remove_zero = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{abundance_weighted}}{default FALSE; whether use abundance of ASVs/OTUs/species. 
\code{FALSE} corresponds to \eqn{FR_{kj}^{unweighted}} in the formula. 
\code{TRUE} corresponds to \eqn{FR_{kj}^{weighted}} in the formula.}

\item{\code{adj_tax}}{default FALSE; 
Whether the adjustment factor (\eqn{AF}) is used. 
The default \code{FALSE} represents the \eqn{AF} is 1, meaning no adjustment is made based on the taxonomic distribution. 
The principle behind the calculation of the adjustment factor is that species with a certain function that are more dispersed taxonomically usually correspond to higher redundancy.
It is defined:
\deqn{AF = \frac{NU_{jk}}{NU_{k}}}
where \eqn{NU_{jk}} denotes the number of unique taxon (at \code{adj_tax_by} level) for those ASVs/OTUs/species with function j in sample k. 
\eqn{NU_{k}} denotes the number of total unique taxon (at \code{adj_tax_by} level) in sample k.
Please use the parameter \code{adj_tax_by} to select other taxonomic rank (default Genus level).
Here is an example: Suppose a sample k contains a total of 10 genera (including unclassified ones in different lineages), 
and 3 ASVs with function j are distributed among 2 genera. In this case, the \eqn{AF} would be \eqn{\frac{2}{10}}, which is 0.2.}

\item{\code{adj_tax_by}}{default "Genus"; When \code{adj_tax = TRUE}, at which taxonomic level is the adjustment factor (\eqn{AF}) calculated?}

\item{\code{perc}}{default FALSE; whether to use percentages in the result. 
The default value of \code{FALSE} means that the result is in the range of 0 to 1. 
If it is \code{TRUE}, the result will be multiplied by 100, meaning the range will be from 0 to 100.}

\item{\code{dec}}{default 6; remained decimal places in the result table.}

\item{\code{remove_zero}}{default TRUE; whether to remove the columns in which the sum equals 0.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{res_func_FR} stored in the object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
t1$cal_func_FR(abundance_weighted = TRUE)
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trans_func-trans_func_FR"></a>}}
\if{latex}{\out{\hypertarget{method-trans_func-trans_func_FR}{}}}
\subsection{Method \code{trans_func_FR()}}{
Transform the \code{res_func_FR} table to the long table format for the following visualization.
Also add the group information if the database has hierarchical groups.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_func$trans_func_FR()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{res_func_FR_trans} stored in the object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
t1$trans_func_FR()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trans_func-plot_func_FR"></a>}}
\if{latex}{\out{\hypertarget{method-trans_func-plot_func_FR}{}}}
\subsection{Method \code{plot_func_FR()}}{
Plot the functional redundancy (FR) results generated by \code{cal_func_FR} and \code{trans_func_FR}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_func$plot_func_FR(
  add_facet = TRUE,
  order_x = NULL,
  color_gradient_low = "#00008B",
  color_gradient_high = "#9E0142"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{add_facet}}{default TRUE; whether use group names as the facets in the plot, see \code{trans_func$func_group_list} object.}

\item{\code{order_x}}{default NULL; character vector; to sort the x axis text; can be also used to select partial samples to show.}

\item{\code{color_gradient_low}}{default "#00008B"; the color used as the low end in the color gradient.}

\item{\code{color_gradient_high}}{default "#9E0142"; the color used as the high end in the color gradient.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
ggplot2.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
t1$plot_func_FR()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trans_func-cal_func_FR_comm"></a>}}
\if{latex}{\out{\hypertarget{method-trans_func-cal_func_FR_comm}{}}}
\subsection{Method \code{cal_func_FR_comm()}}{
Calculate the functional redundancy (FR) of communities based on the the result of \code{cal_func_FR} function.
It is the geometric mean of FR for each function/trait in a community.
It is defined:
     \deqn{FR_{k} = \sqrt[n]{FR_{k1} \times FR_{k2} \times \cdots \times FR_{kn}}}
where \eqn{FR_{k}} denotes the FR at community level for sample k. \eqn{FR_{kn}} represents the FR of function n for sample k.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_func$cal_func_FR_comm()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
vector.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
t1$cal_func_FR_comm()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trans_func-show_prok_func"></a>}}
\if{latex}{\out{\hypertarget{method-trans_func-show_prok_func}{}}}
\subsection{Method \code{show_prok_func()}}{
Show the annotation information for a function of prokaryotes from FAPROTAX database.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_func$show_prok_func(use_func = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{use_func}}{default NULL; the function name in FAPROTAX database.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
none.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
t1$show_prok_func(use_func = "methanotrophy")
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trans_func-cal_tax4fun2"></a>}}
\if{latex}{\out{\hypertarget{method-trans_func-cal_tax4fun2}{}}}
\subsection{Method \code{cal_tax4fun2()}}{
Predict functional potential of communities with Tax4Fun2 method. 
  The function was adapted from the raw Tax4Fun2 package to make it compatible with the microtable object.
  Pleas cite: 
  Tax4Fun2: prediction of habitat-specific functional profiles and functional redundancy based on 16S rRNA gene sequences. Environmental Microbiome 15, 11 (2020).
	 <doi:10.1186/s40793-020-00358-7>
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_func$cal_tax4fun2(
  blast_tool_path = NULL,
  path_to_reference_data = "Tax4Fun2_ReferenceData_v2",
  path_to_temp_folder = NULL,
  database_mode = "Ref99NR",
  normalize_by_copy_number = T,
  min_identity_to_reference = 97,
  use_uproc = T,
  num_threads = 1,
  normalize_pathways = F
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{blast_tool_path}}{default NULL; the folder path, e.g., ncbi-blast-2.5.0+/bin ; blast tools folder downloaded from 
"ftp://ftp.ncbi.nlm.nih.gov/blast/executables/blast+"  ; e.g., ncbi-blast-2.5.0+-x64-win64.tar.gz  for windows system; 
if blast_tool_path is NULL, search the tools in the environmental path variable.}

\item{\code{path_to_reference_data}}{default "Tax4Fun2_ReferenceData_v2"; the path that points to files used in the prediction; 
The directory must contain the Ref99NR or Ref100NR folder; 
download Ref99NR.zip from "https://cloudstor.aarnet.edu.au/plus/s/DkoZIyZpMNbrzSw/download" or 
Ref100NR.zip from "https://cloudstor.aarnet.edu.au/plus/s/jIByczak9ZAFUB4/download".}

\item{\code{path_to_temp_folder}}{default NULL; The temporary folder to store the logfile, intermediate file and result files; if NULL, 
use the default temporary in the computer system.}

\item{\code{database_mode}}{default 'Ref99NR'; "Ref99NR" or "Ref100NR"; Ref99NR: 99\% clustering reference database; Ref100NR: no clustering.}

\item{\code{normalize_by_copy_number}}{default TRUE; whether normalize the result by the 16S rRNA copy number in the genomes.}

\item{\code{min_identity_to_reference}}{default 97; the sequences identity threshold used for finding the nearest species.}

\item{\code{use_uproc}}{default TRUE; whether use UProC to functionally anotate the genomes in the reference data.}

\item{\code{num_threads}}{default 1; the threads used in the blastn.}

\item{\code{normalize_pathways}}{default FALSE; Different to Tax4Fun, when converting from KEGG functions to KEGG pathways, 
   Tax4Fun2 does not equally split KO gene abundances between pathways a functions is affiliated to. The full predicted abundance is affiliated to each pathway. 
Use TRUE to split the abundances (default is FALSE).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{res_tax4fun2_KO} and \code{res_tax4fun2_pathway} in object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
t1$cal_tax4fun2(blast_tool_path = "ncbi-blast-2.5.0+/bin", 
    path_to_reference_data = "Tax4Fun2_ReferenceData_v2")
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trans_func-cal_tax4fun2_FRI"></a>}}
\if{latex}{\out{\hypertarget{method-trans_func-cal_tax4fun2_FRI}{}}}
\subsection{Method \code{cal_tax4fun2_FRI()}}{
Calculate (multi-) functional redundancy index (FRI) of prokaryotic community with Tax4Fun2 method.
This function is used to calculating aFRI and rFRI use the intermediate files generated by the function cal_tax4fun2().
please also cite: 
Tax4Fun2: prediction of habitat-specific functional profiles and functional redundancy based on 16S rRNA gene sequences. 
	 Environmental Microbiome 15, 11 (2020). <doi:10.1186/s40793-020-00358-7>
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_func$cal_tax4fun2_FRI()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
res_tax4fun2_aFRI and res_tax4fun2_rFRI in object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
t1$cal_tax4fun2_FRI()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trans_func-cal_spe_func"></a>}}
\if{latex}{\out{\hypertarget{method-trans_func-cal_spe_func}{}}}
\subsection{Method \code{cal_spe_func()}}{
This is a deprecated function. Please use \code{cal_func} function instead.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_func$cal_spe_func(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{paremeters pass to \code{cal_func}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trans_func-cal_spe_func_perc"></a>}}
\if{latex}{\out{\hypertarget{method-trans_func-cal_spe_func_perc}{}}}
\subsection{Method \code{cal_spe_func_perc()}}{
This is a deprecated function. Please use \code{cal_func_FR} function instead.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_func$cal_spe_func_perc(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{paremeters pass to \code{cal_func_FR}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trans_func-trans_spe_func_perc"></a>}}
\if{latex}{\out{\hypertarget{method-trans_func-trans_spe_func_perc}{}}}
\subsection{Method \code{trans_spe_func_perc()}}{
This is a deprecated function. Please use \code{trans_func_FR} function instead.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_func$trans_spe_func_perc(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{paremeters pass to \code{trans_func_FR}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trans_func-plot_spe_func_perc"></a>}}
\if{latex}{\out{\hypertarget{method-trans_func-plot_spe_func_perc}{}}}
\subsection{Method \code{plot_spe_func_perc()}}{
This is a deprecated function. Please use \code{plot_func_FR} function instead.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_func$plot_spe_func_perc(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{paremeters pass to \code{plot_func_FR}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trans_func-clone"></a>}}
\if{latex}{\out{\hypertarget{method-trans_func-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_func$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
