% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_loading.R
\name{load_builtin_nugis}
\alias{load_builtin_nugis}
\title{Load Built-in NuGIS Data from OSF}
\usage{
load_builtin_nugis(scale, year = 2016, force_download = FALSE, verbose = TRUE)
}
\arguments{
\item{scale}{Character. Spatial scale: "county", "huc8", or "huc2"}

\item{year}{Numeric. Year to filter data (available: 1987-2016)}

\item{force_download}{Logical. Force re-download even if cached}

\item{verbose}{Logical. Show download progress}
}
\value{
Data frame of NuGIS data for specified scale and year
}
\description{
Load built-in NuGIS data from OSF repository for specified year and spatial scale.
Data includes all years from 1987 through 2016.
}
\examples{
\donttest{
# Load county data for 2016
county_2016 <- load_builtin_nugis("county", 2016)

# Load HUC8 data for 2010
huc8_2010 <- load_builtin_nugis("huc8", 2010)

# Load county data for 2010, force fresh download
county_2010 <- load_builtin_nugis("county", 2010, force_download = TRUE)
}
}
