% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workflow_functions.R
\name{batch_analysis_parallel}
\alias{batch_analysis_parallel}
\title{Batch Analysis with Parallel Processing}
\usage{
batch_analysis_parallel(years, n_cores = NULL, ...)
}
\arguments{
\item{years}{Numeric vector. Years to analyze}

\item{n_cores}{Integer. Number of cores (default: detectCores() - 1)}

\item{...}{Arguments passed to run_builtin_analysis}
}
\value{
List of results
}
\description{
Run batch analysis using multiple cores for faster processing
}
\examples{
\donttest{
results <- batch_analysis_parallel(
  years = 2015:2016,  # Use valid years only
  n_cores = 2,        # Max 2 cores for CRAN
  scale = "county",   # Use county for faster processing
  nutrients = "nitrogen"
)
}
}
