% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/locStra.r
\name{bed_fastSMatrixEVs}
\alias{bed_fastSMatrixEVs}
\title{Computation of the k leading eigenvectors of the s-matrix (the weighted Jaccard similarity matrix) directly from a bed+bim+fam file. Note that in contrast to the parameters of the function \code{sMatrix}, the choice \code{phased=FALSE} cannot be modified for the fast eigenvector computation. Moreover, inverting the minor allele is not possible when reading directly from external files.}
\usage{
bed_fastSMatrixEVs(f, k, Djac = FALSE, q = 2)
}
\arguments{
\item{f}{The filename of the bed file (including its extension). The bim and fam files need to be in the same folder and have the same base filename.}

\item{k}{The number of leading eigenvectors.}

\item{Djac}{Flag to switch between the unweighted (\code{Djac=TRUE}) or weighted (\code{Djac=FALSE}) version. Default is \code{Djac=FALSE}.}

\item{q}{The number of power iteration steps (default is \code{q=2}).}
}
\value{
The k leading eigenvectors of the s-matrix of \code{m} as a column matrix.
}
\description{
Computation of the k leading eigenvectors of the s-matrix (the weighted Jaccard similarity matrix) directly from a bed+bim+fam file. Note that in contrast to the parameters of the function \code{sMatrix}, the choice \code{phased=FALSE} cannot be modified for the fast eigenvector computation. Moreover, inverting the minor allele is not possible when reading directly from external files.
}
\examples{
require(locStra)

}
\references{
Daniel Schlauch (2016). Implementation of the stego algorithm - Similarity Test for Estimating Genetic Outliers. https://github.com/dschlauch/stego

N. Halko, P.G. Martinsson, and J.A. Tropp (2011). Finding Structure with Randomness: Probabilistic Algorithms for Constructing Approximate Matrix Decompositions. SIAM Review: 53(2), pp. 217--288.

F. Prive, M. Blum, H. Aschard, B.J. Vilhjalmsson (2022). bigsnpr: Analysis of Massive SNP Arrays. https://cran.r-project.org/package=bigsnpr
}
