% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evalfrbe.R
\name{evalfrbe}
\alias{evalfrbe}
\title{Evaluate the performance of the FRBE forecast}
\usage{
evalfrbe(fit, real, error = c("smape", "mase", "rmse"))
}
\arguments{
\item{fit}{A FRBE model of class \code{frbe} as returned by the \code{\link[=frbe]{frbe()}} function.}

\item{real}{A numeric vector of real (known) values. The vector must
correspond to the values being forecasted, i.e., the length must be the same
as the horizon forecasted by \code{\link[=frbe]{frbe()}}.}

\item{error}{Error measure to be computed. It can be either Symmetric Mean
Absolute Percentage Error (\code{smape}), Mean Absolute Scaled Error (\code{mase}), or
Root Mean Squared Error (\code{rmse}). See also \code{\link[=smape]{smape()}}, \code{\link[=mase]{mase()}}, and \code{\link[=rmse]{rmse()}}
for more details.}
}
\value{
Function returns a data.frame with single row and columns
corresponding to the error of the individual forecasting methods that the
FRBE is computed from. Additionally to this, a column "avg" is added with
error of simple average of the individual forecasting methods and a column
"frbe" with error of the FRBE forecasts.
}
\description{
Take a FRBE forecast and compare it with real values using arbitrary error
function.
}
\details{
Take a FRBE forecast and compare it with real values by evaluating a given
error measure.  FRBE forecast should be made for a horizon of the same value
as length of the vector of real values.
}
\examples{

  # prepare data (from the forecast package)
  library(forecast)
  horizon <- 10
  train <- wineind[-1 * (length(wineind)-horizon+1):length(wineind)]
  test <- wineind[(length(wineind)-horizon+1):length(wineind)]
  f <- frbe(ts(train, frequency=frequency(wineind)), h=horizon)
  evalfrbe(f, test)

}
\references{
Štěpnička, M., Burda, M., Štěpničková, L. Fuzzy Rule Base
Ensemble Generated from Data by Linguistic Associations Mining. FUZZY SET
SYST. 2015.
}
\seealso{
\code{\link[=frbe]{frbe()}}, \code{\link[=smape]{smape()}}, \code{\link[=mase]{mase()}}, \code{\link[=rmse]{rmse()}}
}
\author{
Michal Burda
}
\keyword{models}
\keyword{robust}
