% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-functions.R
\name{.should_run_checks}
\alias{.should_run_checks}
\title{Determine whether context is in-development or deployed.}
\usage{
.should_run_checks()
}
\value{
TRUE if we're not in an installed package, FALSE otherwise
}
\description{
This function is used internally to decide whether to run \code{ireturn()} checks
}
\details{
\code{interfacer::ireturn} checks run if:
\itemize{
\item the option is set: \code{options(interfacer.always_check=TRUE)}.
\item we are locally developing a package and running functions in smoke testing.
\item we are running a package function in \code{testthat}.
\item we are developing functions in the global environment.
\item we are running functions in a \code{testthat} or R CMD check.
\item we are running functions in a vignette in a R CMD check.
\item we are running functions in a vignette interactively.
}

checks are not run if:
\itemize{
\item package referencing \code{interfacer::ireturn} is installed from CRAN or r-universe
\item package referencing \code{interfacer::ireturn} is installed locally using
\code{devtools::install}
\item vignette building directly using \code{knitr} (unless option is set in vignette).
\item vignette building using \code{pkgdown::build_site()}.
}
}
\keyword{internal}
