% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/with_inset.R
\name{map_border}
\alias{map_border}
\title{Add a border around a map plot}
\usage{
map_border(color = "black", linewidth = 1, fill = "white", ...)
}
\arguments{
\item{color}{Border color. Default "black".}

\item{linewidth}{Border line width. Default 1.}

\item{fill}{Background fill color. Default "white".}

\item{...}{Passed to \code{\link[ggplot2:element]{ggplot2::element_rect()}}.}
}
\value{
A ggplot2 theme object to add to a ggplot with \code{+}.
}
\description{
Returns a small theme that draws a rectangular border around the plot area.
Handy for visually separating inset plots from the main plot.
}
\examples{
library(ggplot2)

ggplot(mtcars, aes(mpg, wt)) +
    geom_point() +
    map_border(color = "red", linewidth = 2)

}
