% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSquadMatchsums.R
\name{getSquadMatchsums}
\alias{getSquadMatchsums}
\title{Return a dataframe that contains squad level matchsums for a given match ID}
\usage{
getSquadMatchsums(matches, token, host = "https://api.impect.com")
}
\arguments{
\item{matches}{'IMPECT' match IDs}

\item{token}{bearer token}

\item{host}{host environment}
}
\value{
a dataframe containing the matchsums aggregated per squad for the given match ID
}
\description{
Return a dataframe that contains squad level matchsums for a given match ID
}
\examples{
# Toy example: this will error quickly (no API token)
try(squad_match_sums <- getSquadMatchsums(
  matches = c(0, 1),
  token = "invalid"
))

# Real usage: requires valid Bearer Token from `getAccessToken()`
\dontrun{
squad_match_sums <- getSquadMatchsums(
  matches = c(84248, 158150),
  token = "yourToken"
)
}
}
