% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hypothesize.R
\name{fisher_combine}
\alias{fisher_combine}
\title{Combine Independent P-Values (Fisher's Method)}
\usage{
fisher_combine(...)
}
\arguments{
\item{...}{\code{hypothesis_test} objects to combine, or numeric p-values.
All tests must be independent.}
}
\value{
A \code{hypothesis_test} object of subclass \code{fisher_combined_test}
containing:
\describe{
\item{stat}{Fisher's chi-squared statistic \eqn{-2\sum\log(p_i)}}
\item{p.value}{P-value from \eqn{\chi^2_{2k}} distribution}
\item{dof}{Degrees of freedom (\eqn{2k})}
\item{n_tests}{Number of tests combined}
\item{component_pvals}{Vector of the individual p-values}
}
}
\description{
Combines p-values from independent hypothesis tests into a single
omnibus test using Fisher's method.
}
\details{
Fisher's method is a meta-analytic technique for combining evidence from
multiple independent tests of the same hypothesis (or related hypotheses).
It demonstrates a key principle: \strong{combining hypothesis tests yields a
hypothesis test} (the closure property).

Given \eqn{k} independent p-values \eqn{p_1, \ldots, p_k}, Fisher's
statistic is:

\deqn{X^2 = -2 \sum_{i=1}^{k} \log(p_i)}

Under the global null hypothesis (all individual nulls are true), this
follows a chi-squared distribution with \eqn{2k} degrees of freedom.
}
\section{Why It Works}{

If \eqn{p_i} is a valid p-value under \eqn{H_0}, then \eqn{p_i \sim U(0,1)}.
Therefore \eqn{-2\log(p_i) \sim \chi^2_2}. The sum of independent
chi-squared random variables is also chi-squared with summed degrees of
freedom, giving \eqn{X^2 \sim \chi^2_{2k}}.
}

\section{Interpretation}{

A significant combined p-value indicates that \strong{at least one} of the
individual null hypotheses is likely false, but does not identify which
one(s). Fisher's method is sensitive to any deviation from the global
null, making it powerful when effects exist but liberal when assumptions
are violated.
}

\section{Closure Property (SICP Principle)}{

This function exemplifies the closure property from SICP: the operation
of combining hypothesis tests produces another hypothesis test. The result
can be further combined, adjusted, or analyzed using the same generic
methods (\code{pval()}, \code{test_stat()}, \code{is_significant_at()}, etc.).
}

\examples{
# Scenario: Three independent studies test the same drug effect
# Study 1: p = 0.08 (trend, not significant)
# Study 2: p = 0.12 (not significant)
# Study 3: p = 0.04 (significant at 0.05)

# Combine using raw p-values
combined <- fisher_combine(0.08, 0.12, 0.04)
combined
is_significant_at(combined, 0.05)  # Stronger evidence together

# Or combine hypothesis_test objects directly
t1 <- wald_test(estimate = 1.5, se = 0.9)
t2 <- wald_test(estimate = 0.8, se = 0.5)
t3 <- z_test(rnorm(30, mean = 0.3), mu0 = 0, sigma = 1)

fisher_combine(t1, t2, t3)

# The result is itself a hypothesis_test, so it composes
# (though combining non-independent tests is invalid)

}
\seealso{
\code{\link[=adjust_pval]{adjust_pval()}} for multiple testing correction (different goal)
}
