% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hdr.conf.R
\name{hdrconf}
\alias{hdrconf}
\title{HDRs with confidence intervals}
\usage{
hdrconf(x, den, prob = 0.9, conf = 0.95)
}
\arguments{
\item{x}{Numeric vector containing data.}

\item{den}{Density of data as list with components \code{x} and \code{y}.}

\item{prob}{Probability coverage for for HDRs.}

\item{conf}{Confidence for limits on HDR.}
}
\value{
\code{hdrconf} returns list containing the following components:
\item{hdr}{Highest density regions} \item{hdr.lo}{Highest density regions
corresponding to lower confidence limit.} \item{hdr.hi}{Highest density
regions corresponding to upper confidence limit.} \item{falpha}{Values of
\eqn{f_\alpha}{f[alpha]} corresponding to HDRs.} \item{falpha.ci}{Values of
\eqn{f_\alpha}{f[alpha]} corresponding to lower and upper limits.}
}
\description{
Calculates Highest Density Regions with confidence intervals.
}
\examples{
x <- c(rnorm(100, 0, 1), rnorm(100, 4, 1))
den <- density(x, bw = hdrbw(x, 50))
hdr_conf <- hdrconf(x, den)
plot(hdr_conf, den, main = "50\% HDR with 95\% CI")
}
\references{
Hyndman, R.J. (1996) Computing and graphing highest density
regions \emph{American Statistician}, \strong{50}, 120-126.
}
\seealso{
\code{\link[=hdr]{hdr()}}, \code{\link[=plot.hdrconf]{plot.hdrconf()}}
}
\author{
Rob J Hyndman
}
\keyword{distribution}
\keyword{smooth}
