% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{gamm_radius}
\alias{gamm_radius}
\title{detrending model on tree-ring width series}
\usage{
gamm_radius(data, resp_scale = "resp_gamma", m.candidates)
}
\arguments{
\item{data}{data containing all necessary columns to run the model}

\item{resp_scale}{Character. Specifies how the response variable is treated in the model.
\itemize{
  \item \strong{"resp_gaussian"}: Uses the response on its original scale, assuming a Gaussian distribution with an identity link (no transformation applied).
  \item \strong{"resp_log"}: Log-transforms the response before modelling. The transformed response is then assumed to follow a Gaussian distribution with an identity link.
  \item \strong{"resp_gamma"}: Keeps the response on its original scale, fitted under a Gamma distribution with a log link. Suitable for strictly positive and right-skewed data.
}}

\item{m.candidates}{the list of candidate equations.}
}
\value{
list including model, fitting statistics, ptable, stable and prediction table
}
\description{
models the biological growth trends in individual tree-ring width series using mgcv::gamm
}
\details{
This function models the biological growth trends in individual tree-ring width series using mcgv::gamm.
By integrating a first-order autoregressive (AR1) component, it accounts for temporal autocorrelation.
This method can provide  “normalized” residuals, which are adjusted to reflect deviations after considering the AR1 correlation structure.
'Normalized' residuals are valuable for further analyses, such as investigating relationships with climatic variables.
If users specify multiple candidate models through the m.candidates argument, the function will fit each candidate model using the maximum likelihood (ML) method.
The corrected Akaike Information Criterion (AICc) will then be compared to determine the best-fitting model. Once the optimal model is identified,
it will be refitted using the restricted maximum likelihood (REML) method and output the results.

If users specify only 1 candidate model through the m.candidates argument, the model is fitted with "REML" method.
}
\examples{

# loading processed data
dt.samples_trt <- readRDS(system.file("extdata", "dt.samples_trt.rds", package = "growthTrendR"))
# pre-data for model
dt.samples_long <- prepare_samples_clim(dt.samples_trt)

dt.m <- dt.samples_long[uid_site == 1][ageC >1]

# gamm_radius model
m.radius <-gamm_radius(data = dt.m, resp_scale = "resp_log",
                                       m.candidates = c( "rw_mm ~ s(year)",
                                                         "rw_mm ~ s(year)"))
}
