% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grmforest.R
\name{grmforest}
\alias{grmforest}
\title{Fit a Forest of Graded Response Model Trees for Ensemble-Based DIF Detection}
\usage{
grmforest(formula, data, control = grmforest.control(), ...)
}
\arguments{
\item{formula}{A formula specifying the model structure with the response
matrix on the left and partitioning variables on the right (e.g.,
\code{response_matrix ~ age + gender + education + clinical_variables}).}

\item{data}{A data frame containing the response matrix and partitioning
variables. The response matrix should contain polytomous items coded
as ordered factors.}

\item{control}{A control object created by \code{grmforest.control()}.}

\item{...}{Additional arguments passed to underlying \code{grmtree()} function.}
}
\value{
An object of class \code{grmforest} containing: \item{trees}{List of
fitted GRM trees} \item{oob_samples}{List of out-of-bag samples for each
tree} \item{formula}{The model formula} \item{data}{The original dataset}
\item{call}{The function call}
}
\description{
This function implements a forest of graded response model trees (GRM Forest)
using bootstrap aggregation (bagging) or random subsampling to enhance the
detection and analysis of differential item functioning (DIF) in polytomous items.
The GRM Forest approach combines the strengths of multiple GRMTrees to provide
more robust and stable DIF detection, particularly for complex datasets with
high-dimensional covariates or subtle DIF patterns.
}
\details{
The algorithm works by fitting multiple GRMTrees, each on a random sample of
the original data (either through bootstrap sampling or subsampling). For each
tree, approximately one-third of the observations are left out as out-of-bag
(OOB) samples, which are used for internal validation and variable importance
calculation. The ensemble approach reduces variance, minimizes overfitting,
and provides more reliable identification of covariates associated with DIF.

Key advantages of the GRM Forest approach include:
\itemize{
\item Enhanced stability in DIF detection across different sampling variations
\item Robust variable importance measures that quantify the relative contribution
of each covariate to DIF patterns
\item Reduced false positive rates through consensus-based detection
\item Ability to handle high-dimensional covariate spaces effectively
\item Internal validation through out-of-bag error estimation
}

The forest implementation supports both bootstrap aggregation (where samples
are drawn with replacement) and subsampling (without replacement), allowing
flexibility for different data characteristics and research objectives.
}
\examples{

\donttest{
  library(grmtree)
  library(hlt)
  data("asti", package = "hlt")
  asti$resp <- data.matrix(asti[, 1:4])

  # Fit forest with default parameters
  forest <- grmforest(resp ~ gender + group, data = asti)

  # Fit with custom control
  ctrl <- grmforest.control(n_tree = 50, sampling = "subsample")
  forest <- grmforest(resp ~ gender + group, data = asti, control = ctrl)
}

}
\seealso{
\code{\link{grmtree}} fits a Graded Response Model Tree,
\code{\link{grmtree.control}} creates a control object for \code{grmtree},
\code{\link{grmforest.control}} creates a control object for \code{grmforest},
\code{\link{varimp}} calculates the variable importance for GRM Forest,
\code{\link{plot.varimp}} creates a bar plot of variable importance scores
}
