% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/control.R
\name{dglmstarma.control}
\alias{dglmstarma.control}
\title{Control Parameters for \code{dglmstarma} Fitting}
\usage{
dglmstarma.control(
  parameter_init = "zero",
  parameter_init_dispersion = "zero",
  use_sparsity = TRUE,
  sparsity_threshold = 2/3,
  init_link = "first_obs",
  init_dispersion = "first_obs",
  use_backtracking = TRUE,
  alpha_shrink = 0.5,
  alpha_start = 1,
  min_alpha = 0.05,
  print_progress = TRUE,
  print_warnings = FALSE,
  convergence_threshold = 1e-06,
  max_fits = 50L,
  use_fast_if_const_dispersion = FALSE,
  lower_dispersion = 1e-07,
  upper_dispersion = 1e+06,
  drop_max_mean_lag = TRUE,
  previous_param_as_start = FALSE,
  method = "nloptr",
  constrained_mean = TRUE,
  constrained_dispersion = TRUE,
  constraint_tol = 1e-08,
  constrain_method_mean = "sum_of_absolutes",
  constrain_method_dispersion = "sum_of_absolutes",
  gradtol = sqrt(.Machine$double.eps),
  changetol = sqrt(.Machine$double.eps),
  trace = 0L,
  fnscale = 1,
  maxit = 10000L,
  abstol = -Inf,
  reltol = sqrt(.Machine$double.eps),
  lmm = 5,
  factr = 1e+07,
  pgtol = 0
)
}
\arguments{
\item{parameter_init}{Character or list. Start values for parameter estimation. See details.}

\item{parameter_init_dispersion}{Character or list. Start values for dispersion parameter estimation. See details.}

\item{use_sparsity}{Logical; whether to use sparse matrices for the neighborhood matrices.}

\item{sparsity_threshold}{Numeric in \eqn{[0, 1]}. Threshold for proportion of non-zero elements for considering neighborhood matrices as sparse (default: \code{2/3}).}

\item{init_link}{Character or matrix, specifing how to initialize the linear process of the mean model, if regression on the feedback process is included.
\itemize{
\item \code{"first_obs"}: Use the first (transformed) observed values at each location.
\item \code{"mean"}: Use the mean of the (transformed) observed values at each location.
\item \code{"transformed_mean"}: Calculates the mean of the obsverved values at each location and transforms it by the link function.
\item \code{"zero"}: Use zero as initial value.
\item (numeric matrix) specifying starting values (rows = location, columns = time, must match maximum temporal order of model)
}}

\item{init_dispersion}{Character or matrix, specifing how to initialize the linear process of the dispersion model, if feedback mechanism is included in the dispersion model.
\itemize{
\item \code{"first_obs"}: Use the first (transformed) values at each location.
\item \code{"mean"}: Use the mean of the (transformed) values at each location.
\item \code{"transformed_mean"}: Calculates the mean of the values at each location and transforms it by the link function.
\item \code{"zero"}: Use zero as initial value.
\item (numeric matrix) specifying starting values (rows = location, columns = time, must match maximum temporal order of the dispersion model)
}}

\item{use_backtracking}{Logical; whether to use backtracking line search when updating parameters in the fitting procedure. Default is \code{TRUE}. See details.}

\item{alpha_shrink}{Numeric; shrinkage factor for backtracking line search. Default is \code{0.5}.}

\item{alpha_start}{Numeric; initial step size for backtracking line search. Default is \code{1.0}.}

\item{min_alpha}{Numeric; minimum step size for backtracking line search. Default is \code{0.05}.}

\item{print_progress}{Logical; whether to print progress information during fitting.}

\item{print_warnings}{Logical; whether to print warnings if convergence was not achieved (only applicable if \code{print_progress} is \code{TRUE}).}

\item{convergence_threshold}{Numeric. Convergence threshold for fitting procedure. See details.}

\item{max_fits}{Integer. Maximum number of iterations between fitting mean and dispersion model. See details.}

\item{use_fast_if_const_dispersion}{Logical; whether to use a faster fitting method if the dispersion model is constant, i.e. only an intercept model. See details.}

\item{lower_dispersion}{Numeric. Lower bound for pseudo observations. See details.}

\item{upper_dispersion}{Numeric. Upper bound for pseudo observations. See details.}

\item{drop_max_mean_lag}{Logical; whether to drop the first \code{max_time_lag} observations of the mean model when fitting the dispersion model. Default is \code{TRUE} (recommended).}

\item{previous_param_as_start}{Logical; whether to use the parameter estimates of the previous fitting step as starting values for the next fitting step when iterating between fitting mean and dispersion model. If \code{FALSE}, the initial parameter values specified via \code{parameter_init} and \code{parameter_init_dispersion} are used for each fitting step. Default is \code{FALSE}.}

\item{method}{Character. Optimization method to be used. Options are:
\itemize{
\item \code{"nloptr"} (requires \pkg{nloptr}, default),
\item \code{"optim"} (base R \code{\link{optim}})
}}

\item{constrained_mean}{Logical; whether to use parameter constraints ensuring a stable solution. Only works with \code{method = "nloptr"}.}

\item{constrained_dispersion}{Logical; whether to use parameter constraints ensuring a stable solution for the dispersion model. Only works with \code{method = "nloptr"}.}

\item{constraint_tol}{Numeric. Tolerance for fulfilling constraint.}

\item{constrain_method_mean}{Character. Method for applying parameter constraints.
\itemize{
\item \code{"sum_of_absolutes"}: Sum of absolute values of parameters is constrained
\item \code{"absolute_sum"}: Absolute sum of parameters is constrained. (only intended for univariate models)
\item \code{"soft"}: Constraints for \code{"softplus"} and \code{"softclipping"} link functions (not available for different link functions).
}}

\item{constrain_method_dispersion}{Character. Method for applying parameter constraints for the dispersion model.
\itemize{
\item \code{"sum_of_absolutes"}: Sum of absolute values of parameters is constrained
\item \code{"absolute_sum"}: Absolute sum of parameters is constrained. (only intended for univariate models)
}}

\item{gradtol}{Numeric. Tolerance for gradient convergence. See details.}

\item{changetol}{Numeric. Tolerance for parameter change convergence. See details.}

\item{trace}{Integer. Level of tracing output. See details.}

\item{fnscale}{Numeric. Scaling factor for the objective function. See details.}

\item{maxit}{Integer. Maximum number of iterations. See details.}

\item{abstol}{Numeric. Absolute convergence tolerance. See details.}

\item{reltol}{Numeric. Relative convergence tolerance. See details.}

\item{lmm}{Integer. Limited-memory BFGS parameter. See details.}

\item{factr}{Numeric. Factor for controlling the convergence tolerance. See details.}

\item{pgtol}{Numeric. Tolerance for projected gradient convergence. See details.}
}
\value{
A named list of control parameters
}
\description{
List of control parameters to be passed as an an argument to \code{dglmstarma}.
}
\details{
This function is called internally in \code{dglmstarma} to validate control parameters in the \code{control} argument.

The arguments \code{constraint_tol}, \code{gradtol}, \code{changetol}, \code{trace}, \code{fnscale}, \code{maxit}, \code{abstol}, \code{reltol}, \code{lmm}, \code{factr}, and \code{pgtol} are passed to the optimization routines and control the convergence behavior and output.
Some of these arguments are not used by all optimization methods.

Iteration between fitting the mean and dispersion model stops when relative change in log-likelihood or absolute change in parameters is below \code{convergence_threshold} or when \code{max_fits} is reached.

The \code{optim} method uses the L-BFGS-B algorithm when non-negative parameters are required, otherwise the BFGS algorithm is used. Stability constraints cannot be applied when using \code{optim}.
Only if \code{method = "nloptr"} stability constraints are supported, and the specified \code{constrain_method} is applied. For optimization we use the SLSQP routine. The constraints implied by \code{constrain_method} are given by:
\itemize{
\item \code{"sum_of_absolutes"}: \deqn{\sum_{i = 1}^q\sum_{\ell = 0}^{a_i} | \alpha_{i\ell} | + \sum_{j = 1}^r \sum_{\ell = 0}^{b_j} | \beta_{j\ell} | \leq 1}
\item \code{"absolute_sum"}: \deqn{\left|\sum_{i = 1}^q\sum_{\ell = 0}^{a_i}  \alpha_{i\ell}  + \sum_{j = 1}^r \sum_{\ell = 0}^{b_j}  \beta_{j\ell} \right| \leq 1}
\item \code{"soft"}: \deqn{\sum_{i = 1}^q\sum_{\ell = 0}^{a_i}  \max\lbrace0, \alpha_{i\ell}\rbrace  + \sum_{j = 1}^r \sum_{\ell = 0}^{b_j}  \max\lbrace0, \beta_{j\ell}\rbrace \leq 1} and \deqn{\sum_{i = 1}^q\sum_{\ell = 0}^{a_i} | \alpha_{i\ell} | < 1}
}

To avoid numerical issues when fitting the dispersion model, the pseudo observations are clamped in between \code{lower_dispersion} and \code{upper_dispersion}.

If the dispersion model is constant (i.e., only an intercept), setting \code{use_fast_if_const_dispersion = TRUE} the dispersion parameters are estimated using means or colMeans of the Pearson or deviance residuals instead of optimizing the dispersion model.
Note that this sets the dispersion_link to identity during fitting.

If \code{use_backtracking = TRUE}, the fitting procedure aims to increase the total log-likelihood of the model after each fit by applying a backtracking line search.

Start values for the optimization can be provided as a named list via \code{parameter_init} or as a character. If a named list is provided, these must match the model orders, see \code{\link{glmstarma.sim}}. Otherwise, \code{parameter_init} must be one of the following:
\itemize{
\item \code{"zero"}: All parameters initialized to (near) zero. If parameters must be non-negative a small value within the feasible region is used.
\item \code{"random"}: All parameters initialized to random values in the stationary region of the model.
}
}
\examples{
\donttest{
dat <- load_data("chickenpox", directory = tempdir())
chickenpox <- dat$chickenpox
population_hungary <- dat$population_hungary
W_hungary <- dat$W_hungary
mean_model <- list(past_obs = 1)
dispersion_model <- list(past_obs = 1)
dglmstarma(chickenpox, mean_model, dispersion_model, mean_family = vquasipoisson("log"), 
          dispersion_link = "log", W_hungary,
          control = list(parameter_init = "random", print_progress = FALSE))
}
}
\seealso{
\code{\link{dglmstarma}}, \code{\link[nloptr]{nloptr}}, \code{\link{optim}}
}
